/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetIndex$$anonfun$kafka$log$OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017=3gm]3u\u0013:$W\r\u001f\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0001b\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aC*dC2\fwJ\u00196fGRD\u0001\"\b\u0001\u0003\u0002\u0004%\tAH\u0001\u0005M&dW-F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011C\"\u0001\u0002j_&\u0011A%\t\u0002\u0005\r&dW\r\u0003\u0005'\u0001\t\u0005\r\u0011\"\u0001(\u0003!1\u0017\u000e\\3`I\u0015\fHC\u0001\u0015,!\t9\u0012&\u0003\u0002+1\t!QK\\5u\u0011\u001daS%!AA\u0002}\t1\u0001\u001f\u00132\u0011!q\u0003A!A!B\u0013y\u0012!\u00024jY\u0016\u0004\u0003FA\u00171!\t9\u0012'\u0003\u000231\tAao\u001c7bi&dW\r\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002mA\u0011qcN\u0005\u0003qa\u0011A\u0001T8oO\"A!\b\u0001B\u0001B\u0003%a'A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\u0016\u0003y\u0002\"aF \n\u0005\u0001C\"aA%oi\"A!\t\u0001B\u0001B\u0003%a(A\u0007nCbLe\u000eZ3y'&TX\r\t\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019C\u0015J\u0013\t\u0003\u000f\u0002i\u0011A\u0001\u0005\u0006;\r\u0003\ra\b\u0005\u0006i\r\u0003\rA\u000e\u0005\by\r\u0003\n\u00111\u0001?\u0011\u001da\u0005A1A\u0005\n5\u000bA\u0001\\8dWV\ta\n\u0005\u0002P-6\t\u0001K\u0003\u0002R%\u0006)An\\2lg*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+\r\u0003\u0011)H/\u001b7\n\u0005]\u0003&!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0004Z\u0001\u0001\u0006IAT\u0001\u0006Y>\u001c7\u000e\t\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0003\u0011iW.\u00199\u0016\u0003u\u0003\"AX1\u000e\u0003}S!\u0001\u0019\u0007\u0002\u00079Lw.\u0003\u0002c?\n\u0001R*\u00199qK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0003!iW.\u00199`I\u0015\fHC\u0001\u0015g\u0011\u001da3-!AA\u0002uCa\u0001\u001b\u0001!B\u0013i\u0016!B7nCB\u0004\u0003b\u00026\u0001\u0001\u0004%Ia[\u0001\u0005g&TX-F\u0001m!\ti\u0007/D\u0001o\u0015\ty'+\u0001\u0004bi>l\u0017nY\u0005\u0003c:\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bbB:\u0001\u0001\u0004%I\u0001^\u0001\tg&TXm\u0018\u0013fcR\u0011\u0001&\u001e\u0005\bYI\f\t\u00111\u0001m\u0011\u00199\b\u0001)Q\u0005Y\u0006)1/\u001b>fA!9\u0011\u0010\u0001a\u0001\n\u0003i\u0014AC7bq\u0016sGO]5fg\"91\u0010\u0001a\u0001\n\u0003a\u0018AD7bq\u0016sGO]5fg~#S-\u001d\u000b\u0003QuDq\u0001\f>\u0002\u0002\u0003\u0007a\b\u0003\u0004\u0000\u0001\u0001\u0006KAP\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b\u0005\u000b\u0002\u007fa!A\u0011Q\u0001\u0001A\u0002\u0013\u0005Q'\u0001\u0006mCN$xJ\u001a4tKRD\u0011\"!\u0003\u0001\u0001\u0004%\t!a\u0003\u0002\u001d1\f7\u000f^(gMN,Go\u0018\u0013fcR\u0019\u0001&!\u0004\t\u00111\n9!!AA\u0002YBq!!\u0005\u0001A\u0003&a'A\u0006mCN$xJ\u001a4tKR\u0004\u0003bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u000ee\u0016\fG\rT1ti\u0016sGO]=\u0015\u0005\u0005e\u0001cA$\u0002\u001c%\u0019\u0011Q\u0004\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012A\u00027p_.,\b\u000f\u0006\u0003\u0002\u001a\u0005\u0015\u0002bBA\u0014\u0003?\u0001\rAN\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\b\u0003W\u0001A\u0011BA\u0017\u00031Ig\u000eZ3y'2|GOR8s)\u0015q\u0014qFA\u001d\u0011!\t\t$!\u000bA\u0002\u0005M\u0012aA5eqB\u0019a,!\u000e\n\u0007\u0005]rL\u0001\u0006CsR,')\u001e4gKJDq!a\n\u0002*\u0001\u0007a\u0007C\u0004\u0002>\u0001!I!a\u0010\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR)a(!\u0011\u0002F!A\u00111IA\u001e\u0001\u0004\t\u0019$\u0001\u0004ck\u001a4WM\u001d\u0005\b\u0003\u000f\nY\u00041\u0001?\u0003\u0005q\u0007bBA&\u0001\u0011%\u0011QJ\u0001\ta\"L8/[2bYR)a(a\u0014\u0002R!A\u00111IA%\u0001\u0004\t\u0019\u0004C\u0004\u0002H\u0005%\u0003\u0019\u0001 \t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005)QM\u001c;ssR!\u0011\u0011DA-\u0011\u001d\t9%a\u0015A\u0002yBq!!\u0018\u0001\t\u0003\ty&\u0001\u0004baB,g\u000e\u001a\u000b\u0006Q\u0005\u0005\u0014Q\r\u0005\b\u0003G\nY\u00061\u00017\u0003\u0019ygMZ:fi\"9\u0011qMA.\u0001\u0004q\u0014\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u00051\u0011n\u001d$vY2,\"!a\u001c\u0011\u0007]\t\t(C\u0002\u0002ta\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002x\u0001!\t!!\u001f\u0002\u0011Q\u0014XO\\2bi\u0016$\u0012\u0001\u000b\u0005\b\u0003{\u0002A\u0011AA@\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004Q\u0005\u0005\u0005bBA2\u0003w\u0002\rA\u000e\u0005\b\u0003\u000b\u0003A\u0011BAD\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004Q\u0005%\u0005bBAF\u0003\u0007\u0003\rAP\u0001\bK:$(/[3t\u0011\u001d\ty\t\u0001C\u0001\u0003s\nq\u0002\u001e:j[R{g+\u00197jINK'0\u001a\u0005\b\u0003'\u0003A\u0011AAK\u0003\u0019\u0011Xm]5{KR\u0019\u0001&a&\t\u000f\u0005e\u0015\u0011\u0013a\u0001}\u00059a.Z<TSj,\u0007bBAO\u0001\u0011%\u0011qT\u0001\u000bM>\u00148-Z+o[\u0006\u0004Hc\u0001\u0015\u0002\"\"9\u00111UAN\u0001\u0004i\u0016!A7\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002z\u0005)a\r\\;tQ\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0016A\u00023fY\u0016$X\r\u0006\u0002\u0002p!9\u00111\u0012\u0001\u0005\u0002\u0005EF#\u0001 \t\u000f\u0005U\u0006\u0001\"\u0001\u00022\u0006Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u001d\tI\f\u0001C\u0001\u0003s\nQa\u00197pg\u0016Dq!!0\u0001\t\u0003\ty,\u0001\u0005sK:\fW.\u001a+p)\u0011\ty'!1\t\u000f\u0005\r\u00171\u0018a\u0001?\u0005\ta\rC\u0004\u0002H\u0002!\t!!\u001f\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003Q\u0011x.\u001e8e)>,\u00050Y2u\u001bVdG/\u001b9mKR)a(a4\u0002T\"9\u0011\u0011[Ae\u0001\u0004q\u0014A\u00028v[\n,'\u000fC\u0004\u0002V\u0006%\u0007\u0019\u0001 \u0002\r\u0019\f7\r^8s\u0011\u001d\tI\u000e\u0001C\u0005\u00037\f\u0011\"\\1zE\u0016dunY6\u0016\t\u0005u\u0017Q\u001d\u000b\u0005\u0003?\u0014\t\u0001\u0006\u0003\u0002b\u0006]\b\u0003BAr\u0003Kd\u0001\u0001B\u0006\u0002h\u0006]G\u0011!AC\u0002\u0005%(!\u0001+\u0012\t\u0005-\u0018\u0011\u001f\t\u0004/\u00055\u0018bAAx1\t9aj\u001c;iS:<\u0007cA\f\u0002t&\u0019\u0011Q\u001f\r\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002z\u0006]G\u00111\u0001\u0002|\u0006\u0019a-\u001e8\u0011\u000b]\ti0!9\n\u0007\u0005}\bD\u0001\u0005=Eft\u0017-\\3?\u0011\u001da\u0015q\u001ba\u0001\u0005\u0007\u00012a\u0014B\u0003\u0013\r\u00119\u0001\u0015\u0002\u0005\u0019>\u001c7nB\u0005\u0003\f\t\t\t\u0011#\u0002\u0003\u000e\u0005YqJ\u001a4tKRLe\u000eZ3y!\r9%q\u0002\u0004\n\u0003\t!\u0019\u0011!E\u0003\u0005#\u0019BAa\u0004\t-!9AIa\u0004\u0005\u0002\tUAC\u0001B\u0007\u0011)\u0011IBa\u0004\u0012\u0002\u0013\u0005!1D\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iBK\u0002?\u0005?Y#A!\t\u0011\t\t\r\"QF\u0007\u0003\u0005KQAAa\n\u0003*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005WA\u0012AC1o]>$\u0018\r^5p]&!!q\u0006B\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class OffsetIndex
implements Logging,
ScalaObject {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private volatile int maxEntries;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return OffsetIndex$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public final MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    public final void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public final AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public void maxEntries_$eq(int n) {
        this.maxEntries = n;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public OffsetPosition readLastEntry() {
        return (OffsetPosition)Utils$.MODULE$.inLock(this.lock(), new $anonfun$readLastEntry$1(this));
    }

    public OffsetPosition lookup(long targetOffset$1) {
        return (OffsetPosition)this.maybeLock(this.lock(), new $anonfun$lookup$1(this, targetOffset$1));
    }

    public final int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer idx, long targetOffset) {
        long relOffset = targetOffset - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(idx, 0) > relOffset) {
            return -1;
        }
        int lo = 0;
        int hi = this.entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            int found = this.kafka$log$OffsetIndex$$relativeOffset(idx, mid);
            if ((long)found == relOffset) {
                return mid;
            }
            if ((long)found < relOffset) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        return lo;
    }

    public final int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8);
    }

    public final int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n$1) {
        return (OffsetPosition)this.maybeLock(this.lock(), new $anonfun$entry$1(this, n$1));
    }

    public void append(long offset$1, int position$1) {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$append$1(this, offset$1, position$1));
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long offset$2) {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$truncateTo$1(this, offset$2));
    }

    public final void kafka$log$OffsetIndex$$truncateToEntries(int entries$1) {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$kafka$log$OffsetIndex$$truncateToEntries$1(this, entries$1));
    }

    public void trimToValidSize() {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$trimToValidSize$1(this));
    }

    public void resize(int newSize$1) {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$resize$1(this, newSize$1));
    }

    public final void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer m) {
        try {
            if (m instanceof DirectBuffer) {
                ((DirectBuffer)((Object)m)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new $anonfun$kafka$log$OffsetIndex$$forceUnmap$1(this), (Function0<Throwable>)new $anonfun$kafka$log$OffsetIndex$$forceUnmap$2(this, throwable));
        }
    }

    public void flush() {
        Utils$.MODULE$.inLock(this.lock(), new $anonfun$flush$1(this));
    }

    public boolean delete() {
        this.info((Function0<String>)new $anonfun$delete$1(this));
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public int sizeInBytes() {
        return 8 * this.entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success2 = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public void sanityCheck() {
        Predef$.MODULE$.require(this.entries() == 0 || this.lastOffset() > this.baseOffset(), new $anonfun$sanityCheck$1(this));
        long len$1 = this.file().length();
        Predef$.MODULE$.require(len$1 % 8L == 0L, new $anonfun$sanityCheck$2(this, len$1));
    }

    public final int kafka$log$OffsetIndex$$roundToExactMultiple(int number2, int factor) {
        return factor * (number2 / factor);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        Object exceptionResult1 = null;
        try {
            T t = fun.apply();
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
            return t;
        }
        catch (Throwable throwable) {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
            throw throwable;
        }
    }

    private final MappedByteBuffer liftedTree1$1(boolean bl, RandomAccessFile randomAccessFile) {
        MappedByteBuffer exceptionResult2 = null;
        try {
            if (bl) {
                if (this.maxIndexSize() < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append(BoxesRunTime.boxToInteger(this.maxIndexSize())).toString());
                }
                randomAccessFile.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(this.maxIndexSize(), 8));
            }
            long len = randomAccessFile.length();
            MappedByteBuffer idx = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
            Buffer buffer = bl ? idx.position(0) : idx.position(this.kafka$log$OffsetIndex$$roundToExactMultiple(idx.limit(), 8));
            exceptionResult2 = idx;
            return exceptionResult2;
        }
        finally {
            Utils$.MODULE$.swallow((Function0<Object>)new $anonfun$liftedTree1$1$1(this, randomAccessFile));
        }
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated$1 = this.file().createNewFile();
        RandomAccessFile raf$1 = new RandomAccessFile(this.file(), "rw");
        this.kafka$log$OffsetIndex$$mmap = this.liftedTree1$1(newlyCreated$1, raf$1);
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.maxEntries = this.kafka$log$OffsetIndex$$mmap().limit() / 8;
        this.lastOffset = this.readLastEntry().offset();
        this.debug((Function0<String>)new $anonfun$1(this));
    }
}

