/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.dstats.LogNormal;
import jdplus.tramoseats.base.core.seats.IBiasCorrector;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class DefaultBiasCorrector
implements IBiasCorrector {
    private final boolean bias;

    public DefaultBiasCorrector(boolean bias) {
        this.bias = bias;
    }

    @Override
    public void correctBias(SeatsModel model) {
        if (model.isLogTransformation()) {
            this.correctLogs(model);
        } else {
            this.fillLevels(model);
        }
    }

    private TsData correctStdevForLog(TsData e, TsData s) {
        return e.fastFn(s, (stde, m) -> LogNormal.stdev2((double)m, (double)stde));
    }

    private void fillLevels(SeatsModel model) {
        TsData t;
        TsData y = model.getOriginalSeries();
        SeriesDecomposition.Builder decomp = SeriesDecomposition.builder((DecompositionMode)DecompositionMode.Additive).add(y, ComponentType.Series);
        SeriesDecomposition idecomp = model.getInitialComponents();
        TsData s = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        if (s != null) {
            decomp.add(s, ComponentType.Seasonal);
            TsData se = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev);
            if (se != null) {
                decomp.add(se, ComponentType.Seasonal, ComponentInformation.Stdev);
            }
        }
        if ((t = idecomp.getSeries(ComponentType.Trend, ComponentInformation.Value)) != null) {
            decomp.add(t, ComponentType.Trend);
            TsData te = idecomp.getSeries(ComponentType.Trend, ComponentInformation.Stdev);
            if (te != null) {
                decomp.add(te, ComponentType.Trend, ComponentInformation.Stdev);
            }
        }
        TsData sa = TsData.subtract((TsData)y, (TsData)s);
        decomp.add(sa, ComponentType.SeasonallyAdjusted);
        TsData sae = idecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        if (sae != null) {
            decomp.add(sae, ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        TsData i = TsData.subtract((TsData)sa, (TsData)t);
        decomp.add(i, ComponentType.Irregular);
        TsData ie = idecomp.getSeries(ComponentType.Irregular, ComponentInformation.Stdev);
        if (ie != null) {
            decomp.add(ie, ComponentType.Irregular, ComponentInformation.Stdev);
        }
        this.fillForecasts(idecomp, decomp);
        this.fillBackcasts(idecomp, decomp);
        model.setFinalComponents(decomp.build());
    }

    private void fillForecasts(SeriesDecomposition idecomp, SeriesDecomposition.Builder decomp) {
        TsData fsa;
        TsData fy = idecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
        TsData fs = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast);
        TsData ft = idecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
        TsData fi = idecomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast);
        if (fy == null) {
            fy = TsData.add((TsData)fs, (TsData[])new TsData[]{ft, fi});
            fsa = TsData.add((TsData)ft, (TsData)fi);
        } else {
            fsa = TsData.subtract((TsData)fy, (TsData)fs);
        }
        if (fy == null || fy.isEmpty()) {
            return;
        }
        decomp.add(fy, ComponentType.Series, ComponentInformation.Forecast);
        TsData fye = idecomp.getSeries(ComponentType.Series, ComponentInformation.StdevForecast);
        if (fye != null) {
            decomp.add(fye, ComponentType.Series, ComponentInformation.StdevForecast);
        }
        if (fs != null) {
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
            TsData fse = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast);
            if (fse != null) {
                decomp.add(fse, ComponentType.Seasonal, ComponentInformation.StdevForecast);
            }
        }
        if (ft != null) {
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
            TsData fte = idecomp.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast);
            if (fte != null) {
                decomp.add(fte, ComponentType.Trend, ComponentInformation.StdevForecast);
            }
        }
        if (fsa != null) {
            decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            TsData fsae = idecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            if (fsae != null) {
                decomp.add(fsae, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            }
        }
        if (fi != null) {
            decomp.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
            TsData fie = idecomp.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast);
            if (fie != null) {
                decomp.add(fie, ComponentType.Irregular, ComponentInformation.StdevForecast);
            }
        }
    }

    private void fillBackcasts(SeriesDecomposition idecomp, SeriesDecomposition.Builder decomp) {
        TsData fsa;
        TsData fy = idecomp.getSeries(ComponentType.Series, ComponentInformation.Backcast);
        TsData fs = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Backcast);
        TsData ft = idecomp.getSeries(ComponentType.Trend, ComponentInformation.Backcast);
        TsData fi = idecomp.getSeries(ComponentType.Irregular, ComponentInformation.Backcast);
        if (fy == null) {
            fy = TsData.add((TsData)fs, (TsData[])new TsData[]{ft, fi});
            fsa = TsData.add((TsData)ft, (TsData)fi);
        } else {
            fsa = TsData.subtract((TsData)fy, (TsData)fs);
        }
        if (fy == null || fy.isEmpty()) {
            return;
        }
        decomp.add(fy, ComponentType.Series, ComponentInformation.Backcast);
        TsData fye = idecomp.getSeries(ComponentType.Series, ComponentInformation.StdevBackcast);
        if (fye != null) {
            decomp.add(fye, ComponentType.Series, ComponentInformation.StdevBackcast);
        }
        if (fs != null) {
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Backcast);
            TsData fse = idecomp.getSeries(ComponentType.Seasonal, ComponentInformation.StdevBackcast);
            if (fse != null) {
                decomp.add(fse, ComponentType.Seasonal, ComponentInformation.StdevBackcast);
            }
        }
        if (ft != null) {
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Backcast);
            TsData fte = idecomp.getSeries(ComponentType.Trend, ComponentInformation.StdevBackcast);
            if (fte != null) {
                decomp.add(fte, ComponentType.Trend, ComponentInformation.StdevBackcast);
            }
        }
        if (fsa != null) {
            decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
            TsData fsae = idecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            if (fsae != null) {
                decomp.add(fsae, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            }
        }
        if (fi != null) {
            decomp.add(fi, ComponentType.Irregular, ComponentInformation.Backcast);
            TsData fie = idecomp.getSeries(ComponentType.Irregular, ComponentInformation.StdevBackcast);
            if (fie != null) {
                decomp.add(fie, ComponentType.Irregular, ComponentInformation.StdevBackcast);
            }
        }
    }

    private void correctLogs(SeatsModel model) {
        TsData t;
        TsData i;
        TsData y = model.getOriginalSeries();
        int period = model.getPeriod();
        SeriesDecomposition.Builder decomp = SeriesDecomposition.builder((DecompositionMode)DecompositionMode.Multiplicative).add(y, ComponentType.Series);
        int n = y.length();
        int ny = n - n % period;
        SeriesDecomposition ldecomp = model.getInitialComponents();
        double ibias = 1.0;
        double sbias = 1.0;
        TsData s = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        if (s != null) {
            s = s.exp();
            if (this.bias) {
                sbias = s.getValues().range(0, ny).average();
                s = s.multiply(1.0 / sbias);
            }
            decomp.add(s, ComponentType.Seasonal);
            TsData se = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev);
            if (se != null) {
                decomp.add(this.correctStdevForLog(se, s), ComponentType.Seasonal, ComponentInformation.Stdev);
            }
        }
        if ((i = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value)) != null) {
            i = i.exp();
            if (this.bias) {
                ibias = i.getValues().average();
                i = i.multiply(1.0 / ibias);
            }
            decomp.add(i, ComponentType.Irregular);
            TsData ie = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Stdev);
            if (ie != null) {
                decomp.add(this.correctStdevForLog(ie, i), ComponentType.Irregular, ComponentInformation.Stdev);
            }
        }
        if ((t = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Value)) != null) {
            t = t.exp();
            if (this.bias) {
                double tbias = sbias * ibias;
                t = t.multiply(tbias);
            }
            decomp.add(t, ComponentType.Trend);
            TsData te = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Stdev);
            if (te != null) {
                decomp.add(this.correctStdevForLog(te, t), ComponentType.Trend, ComponentInformation.Stdev);
            }
        }
        TsData sa = TsData.divide((TsData)y, (TsData)s);
        decomp.add(sa, ComponentType.SeasonallyAdjusted);
        TsData sae = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        if (sae != null) {
            decomp.add(this.correctStdevForLog(sae, sa), ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        i = TsData.divide((TsData)sa, (TsData)t);
        decomp.add(i, ComponentType.Irregular);
        this.fillForecasts(ldecomp, decomp, sbias, ibias);
        this.fillBackcasts(ldecomp, decomp, sbias, ibias);
        model.setFinalComponents(decomp.build());
    }

    private void fillForecasts(SeriesDecomposition ldecomp, SeriesDecomposition.Builder decomp, double sbias, double ibias) {
        TsData fsa;
        TsData fy = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
        TsData fs = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast);
        TsData ft = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
        TsData fi = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast);
        if (fy == null) {
            fy = TsData.add((TsData)fs, (TsData[])new TsData[]{ft, fi});
        }
        if (fy == null || fy.isEmpty()) {
            return;
        }
        fy = fy.exp();
        decomp.add(fy, ComponentType.Series, ComponentInformation.Forecast);
        TsData fye = ldecomp.getSeries(ComponentType.Series, ComponentInformation.StdevForecast);
        if (fye != null) {
            decomp.add(this.correctStdevForLog(fye, fy), ComponentType.Series, ComponentInformation.StdevForecast);
        }
        if (fs != null) {
            fs = this.bias ? fs.fn(x -> Math.exp(x) / sbias) : fs.exp();
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
            TsData fse = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast);
            if (fse != null) {
                decomp.add(this.correctStdevForLog(fse, fs), ComponentType.Seasonal, ComponentInformation.StdevForecast);
            }
        }
        if (ft != null) {
            if (this.bias) {
                double tbias = sbias * ibias;
                ft = ft.fn(x -> Math.exp(x) * tbias);
            } else {
                ft = ft.exp();
            }
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
            TsData fte = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast);
            if (fte != null) {
                decomp.add(this.correctStdevForLog(fte, ft), ComponentType.Trend, ComponentInformation.StdevForecast);
            }
        }
        if ((fsa = TsData.divide((TsData)fy, (TsData)fs)) != null) {
            decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            TsData fsae = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            if (fsae != null) {
                decomp.add(this.correctStdevForLog(fsae, fsa), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            }
        }
        if ((fi = TsData.divide((TsData)fsa, (TsData)ft)) != null) {
            decomp.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
            TsData fie = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast);
            if (fie != null) {
                decomp.add(this.correctStdevForLog(fie, fi), ComponentType.Irregular, ComponentInformation.StdevForecast);
            }
        }
    }

    private void fillBackcasts(SeriesDecomposition ldecomp, SeriesDecomposition.Builder decomp, double sbias, double ibias) {
        TsData fsa;
        TsData fy = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Backcast);
        TsData fs = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Backcast);
        TsData ft = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Backcast);
        TsData fi = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Backcast);
        if (fy == null) {
            fy = TsData.add((TsData)fs, (TsData[])new TsData[]{ft, fi});
        }
        if (fy == null || fy.isEmpty()) {
            return;
        }
        fy = fy.exp();
        decomp.add(fy, ComponentType.Series, ComponentInformation.Backcast);
        TsData fye = ldecomp.getSeries(ComponentType.Series, ComponentInformation.StdevBackcast);
        if (fye != null) {
            decomp.add(this.correctStdevForLog(fye, fy), ComponentType.Series, ComponentInformation.StdevBackcast);
        }
        if (fs != null) {
            fs = this.bias ? fs.fn(x -> Math.exp(x) / sbias) : fs.exp();
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Backcast);
            TsData fse = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.StdevBackcast);
            if (fse != null) {
                decomp.add(this.correctStdevForLog(fse, fs), ComponentType.Seasonal, ComponentInformation.StdevBackcast);
            }
        }
        if (ft != null) {
            if (this.bias) {
                double tbias = sbias * ibias;
                ft = ft.fn(x -> Math.exp(x) * tbias);
            } else {
                ft = ft.exp();
            }
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Backcast);
            TsData fte = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.StdevBackcast);
            if (fte != null) {
                decomp.add(this.correctStdevForLog(fte, ft), ComponentType.Trend, ComponentInformation.StdevBackcast);
            }
        }
        if ((fsa = TsData.divide((TsData)fy, (TsData)fs)) != null) {
            decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
            TsData fsae = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            if (fsae != null) {
                decomp.add(this.correctStdevForLog(fsae, fsa), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            }
        }
        if ((fi = TsData.divide((TsData)fsa, (TsData)ft)) != null) {
            decomp.add(fi, ComponentType.Irregular, ComponentInformation.Backcast);
            TsData fie = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.StdevBackcast);
            if (fie != null) {
                decomp.add(this.correctStdevForLog(fie, fi), ComponentType.Irregular, ComponentInformation.StdevBackcast);
            }
        }
    }
}

