/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.matrices;

import jdplus.toolkit.base.api.advanced.algebra.Ring;
import jdplus.toolkit.base.api.advanced.matrices.MatrixOperationsLoader;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import lombok.Generated;

public final class MatrixOperations {
    private static final MatrixOperationsLoader.Processor PROCESSOR = new MatrixOperationsLoader.Processor();

    public static void setProcessor(Processor processor) {
        PROCESSOR.set(processor);
    }

    public static Processor getProcessor() {
        return PROCESSOR.get();
    }

    public static Matrix plus(Matrix left, Matrix right) {
        return PROCESSOR.get().plus(left, right);
    }

    public static Matrix plus(Matrix M, double d) {
        return PROCESSOR.get().plus(M, d);
    }

    public static Matrix minus(Matrix left, Matrix right) {
        return PROCESSOR.get().minus(left, right);
    }

    public static Matrix minus(Matrix M, double d) {
        return PROCESSOR.get().minus(M, d);
    }

    public static Matrix times(Matrix left, Matrix right) {
        return PROCESSOR.get().times(left, right);
    }

    public static Matrix times(Matrix M, double d) {
        return PROCESSOR.get().times(M, d);
    }

    public static Matrix opposite(Matrix M) {
        return PROCESSOR.get().opposite(M);
    }

    public static Matrix inv(Matrix M) {
        return PROCESSOR.get().inv(M);
    }

    public static Matrix transpose(Matrix M) {
        return PROCESSOR.get().transpose(M);
    }

    public static Matrix XXt(Matrix X) {
        return PROCESSOR.get().XXt(X);
    }

    public static Matrix XtX(Matrix X) {
        return PROCESSOR.get().XtX(X);
    }

    @Generated
    private MatrixOperations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor
    extends Ring<Matrix> {
        @Override
        public Matrix plus(Matrix var1, double var2);

        @Override
        public Matrix minus(Matrix var1, double var2);

        @Override
        public Matrix times(Matrix var1, double var2);

        public Matrix inv(Matrix var1);

        public Matrix transpose(Matrix var1);

        public Matrix XXt(Matrix var1);

        public Matrix XtX(Matrix var1);
    }
}

