/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.ResamplePatterns;
import dr.evolution.alignment.SiteList;
import dr.math.MathUtils;

public class ShuffledSiteList
extends ResamplePatterns
implements SiteList {
    int[] siteIndices = null;

    public ShuffledSiteList() {
    }

    public ShuffledSiteList(SiteList siteList) {
        this.setPatterns(siteList);
    }

    @Override
    public void setPatterns(SiteList siteList) {
        this.patterns = siteList;
        this.resamplePatterns();
    }

    @Override
    public void resamplePatterns() {
        int n = this.patterns.getSiteCount();
        this.siteIndices = MathUtils.shuffled(n);
    }

    @Override
    public int getSiteCount() {
        return this.siteIndices.length;
    }

    @Override
    public int[] getSitePattern(int n) {
        return this.patterns.getSitePattern(this.siteIndices[n]);
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        return this.patterns.getUncertainSitePattern(this.siteIndices[n]);
    }

    @Override
    public int getPatternIndex(int n) {
        return this.patterns.getPatternIndex(this.siteIndices[n]);
    }

    @Override
    public int getState(int n, int n2) {
        return this.patterns.getState(n, this.siteIndices[n2]);
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        return this.patterns.getUncertainState(n, this.siteIndices[n2]);
    }

    @Override
    public boolean areUncertain() {
        return false;
    }
}

