/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.samples;

import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Population {
    public static final int UNKNOWN_SIZE = -1;
    public static final Population UNKNOWN = new Population(-1, Double.NaN, Double.NaN, false);
    public static final Population ZEROMEAN = new Population(-1, 0.0, Double.NaN, true);
    private final int size;
    private final double mean;
    private final double variance;
    private final boolean normal;

    @Generated
    Population(int size, double mean, double variance, boolean normal) {
        this.size = size;
        this.mean = mean;
        this.variance = variance;
        this.normal = normal;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public double getMean() {
        return this.mean;
    }

    @Generated
    public double getVariance() {
        return this.variance;
    }

    @Generated
    public boolean isNormal() {
        return this.normal;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Population)) {
            return false;
        }
        Population other = (Population)o;
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (Double.compare(this.getMean(), other.getMean()) != 0) {
            return false;
        }
        if (Double.compare(this.getVariance(), other.getVariance()) != 0) {
            return false;
        }
        return this.isNormal() == other.isNormal();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $variance = Double.doubleToLongBits(this.getVariance());
        result = result * 59 + (int)($variance >>> 32 ^ $variance);
        result = result * 59 + (this.isNormal() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Population(size=" + this.getSize() + ", mean=" + this.getMean() + ", variance=" + this.getVariance() + ", normal=" + this.isNormal() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private int size;
        @Generated
        private double mean;
        @Generated
        private double variance;
        @Generated
        private boolean normal;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder size(int size) {
            this.size = size;
            return this;
        }

        @Generated
        public @NonNull Builder mean(double mean) {
            this.mean = mean;
            return this;
        }

        @Generated
        public @NonNull Builder variance(double variance) {
            this.variance = variance;
            return this;
        }

        @Generated
        public @NonNull Builder normal(boolean normal) {
            this.normal = normal;
            return this;
        }

        @Generated
        public @NonNull Population build() {
            return new Population(this.size, this.mean, this.variance, this.normal);
        }

        @Generated
        public @NonNull String toString() {
            return "Population.Builder(size=" + this.size + ", mean=" + this.mean + ", variance=" + this.variance + ", normal=" + this.normal + ")";
        }
    }

    public static class PopulationBuilder {
        private int size = -1;
        private double mean;
        private double variance = Double.NaN;
        private boolean normal = true;
    }
}

