/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.DataResults;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.univariate.IDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class DefaultDisturbanceSmoothingResults
implements IDisturbanceSmoothingResults {
    private final DataBlockResults U = new DataBlockResults();
    private final MatrixResults UVar;
    private final DataResults e;
    private final DataResults evar;

    private DefaultDisturbanceSmoothingResults(boolean cov, boolean err) {
        MatrixResults matrixResults = this.UVar = cov ? new MatrixResults() : null;
        if (err) {
            this.e = new DataResults();
            this.evar = cov ? new DataResults() : null;
        } else {
            this.e = null;
            this.evar = null;
        }
    }

    public static DefaultDisturbanceSmoothingResults full(boolean err) {
        return new DefaultDisturbanceSmoothingResults(true, err);
    }

    public static DefaultDisturbanceSmoothingResults light(boolean err) {
        return new DefaultDisturbanceSmoothingResults(false, err);
    }

    @Override
    public void saveSmoothedTransitionDisturbances(int t, DataBlock u, FastMatrix uvar) {
        this.U.save(t, u);
        if (this.UVar != null && uvar != null) {
            this.UVar.save(t, uvar);
        }
    }

    @Override
    public void saveSmoothedMeasurementDisturbance(int t, double err, double v) {
        if (this.e == null) {
            return;
        }
        this.e.save(t, err);
        if (this.evar != null) {
            this.evar.save(t, v);
        }
    }

    public DataBlock uComponent(int item) {
        return this.U.item(item);
    }

    public DataBlock uComponentVar(int item) {
        return this.UVar.item(item, item);
    }

    public DataBlock e() {
        return this.e.all();
    }

    public DataBlock evar() {
        return this.evar.all();
    }

    @Override
    public DataBlock u(int pos) {
        return this.U.datablock(pos);
    }

    @Override
    public FastMatrix uVar(int pos) {
        return this.UVar == null ? null : this.UVar.matrix(pos);
    }

    @Override
    public double e(int pos) {
        return this.e == null ? 0.0 : this.e.get(pos);
    }

    @Override
    public double eVar(int pos) {
        return this.evar == null ? 0.0 : this.evar.get(pos);
    }

    public int getStart() {
        return this.U.getStartSaving();
    }

    @Override
    public void prepare(ISsf ssf, int start, int end) {
        ISsfDynamics dynamics = ssf.dynamics();
        int edim = dynamics.getInnovationsDim();
        if (this.e != null) {
            this.e.prepare(start, end);
            if (this.evar != null) {
                this.evar.prepare(start, end);
            }
        }
        this.U.prepare(edim, start, end);
        if (this.UVar != null) {
            this.UVar.prepare(edim, start, end);
        }
    }

    @Override
    public void rescaleVariances(double factor) {
        if (this.evar != null) {
            this.evar.rescale(factor);
        }
        if (this.UVar != null) {
            this.UVar.rescale(factor);
        }
        double se = Math.sqrt(factor);
        this.U.rescale(se);
    }
}

