/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.basic.TimeInvariantLoading;

public class Loading {
    public static ISsfLoading optimize(ISsfLoading l, int len) {
        if (!l.isTimeInvariant()) {
            return l;
        }
        DataBlock z = DataBlock.make(len);
        l.Z(0, z);
        IntList c = new IntList();
        DoubleSeqCursor.OnMutable reader = z.cursor();
        double cur = 0.0;
        boolean same = true;
        int n0 = 0;
        for (int k = 0; k < len; ++k) {
            double x = reader.getAndNext();
            if (x == 0.0) {
                ++n0;
                continue;
            }
            if (!same) continue;
            if (cur == 0.0) {
                cur = x;
                c.add(k);
                continue;
            }
            if (cur == x) {
                c.add(k);
                continue;
            }
            same = false;
        }
        if (!same) {
            if (n0 < 2 * len / 3) {
                return new TimeInvariantLoading(z);
            }
            return l;
        }
        if (c.size() == 1) {
            return cur == 1.0 ? Loading.fromPosition(c.get(0)) : Loading.from(c.get(0), cur);
        }
        int[] pos = c.toArray();
        return cur == 0.0 ? Loading.fromPositions(pos) : Loading.rescale(Loading.fromPositions(pos), cur);
    }

    public static ISsfLoading fromPosition(int mpos) {
        return mpos == 0 ? Loading1.L0 : new Loading1(mpos);
    }

    public static ISsfLoading from(int mpos, double b) {
        return b == 1.0 ? Loading.fromPosition(mpos) : new Loading1l(mpos, b);
    }

    public static ISsfLoading sum() {
        return new SumLoading();
    }

    public static ISsfLoading createPartialSum(int n) {
        return new PartialSumLoading(n);
    }

    public static ISsfLoading fromPositions(int[] mpos) {
        return new Loading2(mpos);
    }

    public static ISsfLoading from(int[] mpos, double[] w) {
        return new Loading3(mpos, w);
    }

    public static ISsfLoading circular(int period) {
        return new CircularLoading(period, 0);
    }

    public static ISsfLoading circular(int period, int pstart) {
        return new CircularLoading(period, pstart);
    }

    public static ISsfLoading cyclical(int period) {
        return new CyclicalLoading(period, 0);
    }

    public static ISsfLoading cyclical(int period, int pstart) {
        return new CyclicalLoading(period, pstart);
    }

    public static ISsfLoading periodic(int period, int start) {
        return new PeriodicLoading(period, start);
    }

    public static ISsfLoading regression(FastMatrix X) {
        return new RegressionLoading(X);
    }

    public static ISsfLoading regression(DoubleSeq x) {
        return new SingleRegressionLoading(x);
    }

    public static ISsfLoading rescale(ISsfLoading loading, double s) {
        if (s == 1.0) {
            return loading;
        }
        return new MLoading(loading, s);
    }

    public static ISsfLoading rescale(ISsfLoading loading, double[] s) {
        if (s.length == 1) {
            return Loading.rescale(loading, s[0]);
        }
        return new ALoading(loading, s);
    }

    private static class Loading1
    implements ISsfLoading {
        static Loading1 L0 = new Loading1(0);
        private final int mpos;

        Loading1(int mpos) {
            this.mpos = mpos;
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return m.get(this.mpos);
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.copy(m.row(this.mpos));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return V.get(this.mpos, this.mpos);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            V.add(this.mpos, this.mpos, d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.add(this.mpos, d);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(this.mpos, 1.0);
        }
    }

    private static class Loading1l
    implements ISsfLoading {
        private final int mpos;
        private final double b;
        private final double b2;

        Loading1l(int mpos, double b) {
            this.mpos = mpos;
            this.b = b;
            this.b2 = b * b;
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.b * m.get(this.mpos);
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.setAY(this.b, m.row(this.mpos));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return this.b2 * V.get(this.mpos, this.mpos);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            V.add(this.mpos, this.mpos, d * this.b2);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.add(this.mpos, d * this.b);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(this.mpos, this.b);
        }
    }

    private static class SumLoading
    implements ISsfLoading {
        SumLoading() {
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return m.sum();
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.set(i -> m.column(i).sum());
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return V.sum();
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            V.add(d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.add(d);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(1.0);
        }
    }

    private static class PartialSumLoading
    implements ISsfLoading {
        private final int cdim;

        PartialSumLoading(int n) {
            this.cdim = n;
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return m.extract(0, this.cdim).sum();
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.set(m.row(0), m.row(1), (x, y) -> x + y);
            for (int r = 2; r < this.cdim; ++r) {
                zm.add(m.row(r));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return V.extract(0, this.cdim, 0, this.cdim).sum();
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            V.extract(0, this.cdim, 0, this.cdim).add(d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.extract(0, this.cdim).add(d);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.extract(0, this.cdim).set(1.0);
        }
    }

    static class Loading2
    implements ISsfLoading {
        private final int[] mpos;

        Loading2(int[] mpos) {
            this.mpos = mpos;
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            int n = this.mpos.length;
            double d = m.get(this.mpos[0]);
            for (int i = 1; i < n; ++i) {
                d += m.get(this.mpos[i]);
            }
            return d;
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.copy(m.row(this.mpos[0]));
            for (int i = 1; i < this.mpos.length; ++i) {
                zm.add(m.row(this.mpos[i]));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            double d = 0.0;
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                d += V.get(this.mpos[i], this.mpos[i]);
                for (int j = 0; j < i; ++j) {
                    d += 2.0 * V.get(this.mpos[i], this.mpos[j]);
                }
            }
            return d;
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    V.add(this.mpos[i], this.mpos[j], d);
                }
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            if (d == 0.0) {
                return;
            }
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                x.add(this.mpos[i], d);
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                z.set(this.mpos[i], 1.0);
            }
        }
    }

    static class Loading3
    implements ISsfLoading {
        private final int[] mpos;
        private final double[] w;

        Loading3(int[] mpos, double[] w) {
            this.mpos = mpos;
            this.w = w;
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            int n = this.mpos.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += this.w[i] * m.get(this.mpos[i]);
            }
            return d;
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.setAY(this.w[0], m.row(this.mpos[0]));
            for (int i = 1; i < this.mpos.length; ++i) {
                zm.addAY(this.w[i], m.row(this.mpos[i]));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            double d = 0.0;
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                double wi = this.w[i];
                d += V.get(this.mpos[i], this.mpos[i]) * wi * wi;
                for (int j = 0; j < i; ++j) {
                    double wj = this.w[j];
                    d += 2.0 * V.get(this.mpos[i], this.mpos[j]) * wi * wj;
                }
            }
            return d;
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                double wi = this.w[i];
                for (int j = 0; j < n; ++j) {
                    double wj = this.w[j];
                    V.add(this.mpos[i], this.mpos[j], d * wi * wj);
                }
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            if (d == 0.0) {
                return;
            }
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                x.add(this.mpos[i], d * this.w[i]);
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            int n = this.mpos.length;
            for (int i = 0; i < n; ++i) {
                z.set(this.mpos[i], this.w[i]);
            }
        }
    }

    static class CircularLoading
    implements ISsfLoading {
        private final int period;
        private final int start;

        public CircularLoading(int period, int start) {
            this.period = period;
            this.start = start;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                z.set(-1.0);
            } else {
                z.set(spos, 1.0);
            }
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                return -x.sum();
            }
            return x.get(spos);
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock x) {
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                for (int i = 0; i < x.length(); ++i) {
                    x.set(i, -m.column(i).sum());
                }
            } else {
                x.copy(m.row(spos));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix vm) {
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                return vm.sum();
            }
            return vm.get(spos, spos);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                vm.add(d);
            } else {
                vm.add(spos, spos, d);
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            if (d == 0.0) {
                return;
            }
            int spos = (this.start + pos) % this.period;
            if (spos == this.period - 1) {
                x.add(-d);
            } else {
                x.add(spos, d);
            }
        }
    }

    static class CyclicalLoading
    implements ISsfLoading {
        private final int period;
        private final int start;

        public CyclicalLoading(int period, int start) {
            this.period = period;
            this.start = start;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            int spos = (this.start + pos) % this.period;
            z.set(spos, 1.0);
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            int spos = (this.start + pos) % this.period;
            return x.get(spos);
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock x) {
            int spos = (this.start + pos) % this.period;
            x.copy(m.row(spos));
        }

        @Override
        public double ZVZ(int pos, FastMatrix vm) {
            int spos = (this.start + pos) % this.period;
            return vm.get(spos, spos);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            int spos = (this.start + pos) % this.period;
            vm.add(spos, spos, d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            if (d == 0.0) {
                return;
            }
            int spos = (this.start + pos) % this.period;
            x.add(spos, d);
        }
    }

    static class PeriodicLoading
    implements ISsfLoading {
        private final int period;
        private final int pos;

        public PeriodicLoading(int period, int pos) {
            this.period = period;
            this.pos = pos;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int t, DataBlock z) {
            if (t % this.period == this.pos) {
                z.set(0, 1.0);
            }
        }

        @Override
        public double ZX(int t, DataBlock x) {
            if (t % this.period == this.pos) {
                return x.get(0);
            }
            return 0.0;
        }

        @Override
        public void ZM(int t, FastMatrix m, DataBlock x) {
            if (t % this.period == this.pos) {
                x.copy(m.row(0));
            } else {
                x.set(0.0);
            }
        }

        @Override
        public double ZVZ(int t, FastMatrix vm) {
            if (t % this.period == this.pos) {
                return vm.get(0, 0);
            }
            return 0.0;
        }

        @Override
        public void VpZdZ(int t, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            if (t % this.period == this.pos) {
                vm.add(0, 0, d);
            }
        }

        @Override
        public void XpZd(int t, DataBlock x, double d) {
            if (d == 0.0) {
                return;
            }
            if (t % this.period == this.pos) {
                x.add(0, d);
            }
        }
    }

    private static class RegressionLoading
    implements ISsfLoading {
        private final FastMatrix data;

        private RegressionLoading(FastMatrix data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.copy(this.data.row(pos));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            return x.dot(this.data.row(pos));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return QuadraticForm.apply(V, this.data.row(pos));
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            V.addXaXt(d, this.data.row(pos));
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.addAY(d, this.data.row(pos));
        }
    }

    private static class SingleRegressionLoading
    implements ISsfLoading {
        private final double[] data;

        private SingleRegressionLoading(DoubleSeq data) {
            this.data = data.toArray();
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        double reg(int pos) {
            return pos < this.data.length ? this.data[pos] : 0.0;
        }

        double reg2(int pos) {
            return pos < this.data.length ? this.data[pos] * this.data[pos] : 0.0;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(0, this.reg(pos));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            return x.get(0) * this.reg(pos);
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return V.get(0, 0) * this.reg2(pos);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            V.add(0, 0, d * this.reg2(pos));
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.add(0, d * this.reg(pos));
        }
    }

    private static class MLoading
    implements ISsfLoading {
        private final ISsfLoading loading;
        private final double s;
        private final double s2;

        private MLoading(ISsfLoading loading, double s) {
            this.loading = loading;
            this.s = s;
            this.s2 = s * s;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            this.loading.Z(pos, z);
            z.mul(this.s);
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.s * this.loading.ZX(pos, m);
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return this.s2 * this.loading.ZVZ(pos, V);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            this.loading.VpZdZ(pos, V, d * this.s2);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.loading.XpZd(pos, x, d * this.s);
        }

        @Override
        public boolean isTimeInvariant() {
            return this.loading.isTimeInvariant();
        }
    }

    private static class ALoading
    implements ISsfLoading {
        private final ISsfLoading loading;
        private final double[] s;

        private ALoading(ISsfLoading loading, double[] s) {
            this.loading = loading;
            this.s = s;
        }

        private double l(int pos) {
            return pos < this.s.length ? this.s[pos] : this.s[this.s.length - 1];
        }

        private double l2(int pos) {
            double z = this.l(pos);
            return z * z;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            this.loading.Z(pos, z);
            z.mul(this.l(pos));
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.l(pos) * this.loading.ZX(pos, m);
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return this.l2(pos) * this.loading.ZVZ(pos, V);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            this.loading.VpZdZ(pos, V, d * this.l2(pos));
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.loading.XpZd(pos, x, d * this.l(pos));
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }
}

