/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public final class Validations {
    @NonNull
    public static <T extends CharSequence> T notBlank(@NonNull T actual, @NonNull String message) throws IllegalArgumentException {
        if (actual == null) {
            throw new NullPointerException("actual is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return (T)Validations.notBlank(actual, (? super T o) -> message);
    }

    @NonNull
    public static <T extends CharSequence> T notBlank(@NonNull T actual, @NonNull Function<? super T, String> message) throws IllegalArgumentException {
        if (actual == null) {
            throw new NullPointerException("actual is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (Validations.isBlank(actual)) {
            throw new IllegalArgumentException(message.apply(actual));
        }
        return actual;
    }

    private static boolean isBlank(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return text.length() == 0 || text.chars().anyMatch(Character::isWhitespace);
    }

    public static int min(int actual, int expected, @NonNull String message) throws IllegalArgumentException {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return Validations.min(actual, expected, (int o) -> message);
    }

    public static int min(int actual, int expected, @NonNull IntFunction<String> message) throws IllegalArgumentException {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (expected > actual) {
            throw new IllegalArgumentException(message.apply(actual));
        }
        return actual;
    }

    @NonNull
    public static <T> Collection<T> atLeast(@NonNull Collection<T> actual, int expected, @NonNull String message) throws IllegalArgumentException {
        if (actual == null) {
            throw new NullPointerException("actual is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return Validations.atLeast(actual, expected, (int o) -> message);
    }

    @NonNull
    public static <T> Collection<T> atLeast(@NonNull Collection<T> actual, int expected, @NonNull IntFunction<String> message) throws IllegalArgumentException {
        if (actual == null) {
            throw new NullPointerException("actual is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (expected > actual.size()) {
            throw new IllegalArgumentException(message.apply(actual.size()));
        }
        return actual;
    }

    public static <T> T on(T actual, @NonNull Predicate<T> expected, @NonNull String message) throws IllegalArgumentException {
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return (T)Validations.on(actual, expected, (? super T o) -> message);
    }

    public static <T> T on(T actual, @NonNull Predicate<T> expected, @NonNull Function<? super T, String> message) throws IllegalArgumentException {
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!expected.test(actual)) {
            throw new IllegalArgumentException(message.apply(actual));
        }
        return actual;
    }

    @Generated
    private Validations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

