/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.math.matrices.MatrixOperationsLoader;
import lombok.Generated;

public final class MatrixOperations {
    private static final MatrixOperationsLoader.Computer COMPUTER = new MatrixOperationsLoader.Computer();

    public static void setComputer(Computer computer) {
        COMPUTER.set(computer);
    }

    public static Computer getComputer() {
        return COMPUTER.get();
    }

    public static Matrix At(Matrix A) {
        return MatrixOperations.getComputer().At(A);
    }

    public static Matrix AB(Matrix A, Matrix B) {
        return MatrixOperations.getComputer().AB(A, B);
    }

    public static Matrix ABt(Matrix A, Matrix B) {
        return MatrixOperations.getComputer().ABt(A, B);
    }

    public static Matrix AtB(Matrix A, Matrix B) {
        return MatrixOperations.getComputer().AtB(A, B);
    }

    @Generated
    private MatrixOperations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Computer {
        public Matrix At(Matrix var1);

        public Matrix AB(Matrix var1, Matrix var2);

        public Matrix ABt(Matrix var1, Matrix var2);

        public Matrix AtB(Matrix var1, Matrix var2);
    }

    public static final class UpperTriangular {
        private static final MatrixOperationsLoader.UpperTriangularComputer COMPUTER = new MatrixOperationsLoader.UpperTriangularComputer();

        public static void setComputer(UpperTriangularComputer computer) {
            COMPUTER.set(computer);
        }

        public static UpperTriangularComputer getComputer() {
            return COMPUTER.get();
        }

        public static Matrix t(Matrix L) {
            return UpperTriangular.getComputer().t(L);
        }

        public static Matrix inverse(Matrix U) {
            return UpperTriangular.getComputer().inverse(U);
        }

        public static DoubleSeq solveUx(Matrix U, DoubleSeq b) {
            return UpperTriangular.getComputer().solveUx(U, b);
        }

        public static DoubleSeq solvexU(Matrix U, DoubleSeq b) {
            return UpperTriangular.getComputer().solvexU(U, b);
        }

        @Generated
        private UpperTriangular() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        @InterchangeableProcessor
        public static interface UpperTriangularComputer {
            public Matrix inverse(Matrix var1);

            public Matrix t(Matrix var1);

            public DoubleSeq solveUx(Matrix var1, DoubleSeq var2);

            public DoubleSeq solvexU(Matrix var1, DoubleSeq var2);
        }
    }

    public static final class LowerTriangular {
        private static final MatrixOperationsLoader.LowerTriangularComputer COMPUTER = new MatrixOperationsLoader.LowerTriangularComputer();

        public static void setComputer(LowerTriangularComputer computer) {
            COMPUTER.set(computer);
        }

        public static LowerTriangularComputer getComputer() {
            return COMPUTER.get();
        }

        public static Matrix t(Matrix L) {
            return LowerTriangular.getComputer().t(L);
        }

        public static Matrix inverse(Matrix L) {
            return LowerTriangular.getComputer().inverse(L);
        }

        public static DoubleSeq solveLx(Matrix L, DoubleSeq b) {
            return LowerTriangular.getComputer().solveLx(L, b);
        }

        public static DoubleSeq solvexL(Matrix L, DoubleSeq b) {
            return LowerTriangular.getComputer().solvexL(L, b);
        }

        @Generated
        private LowerTriangular() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        @InterchangeableProcessor
        public static interface LowerTriangularComputer {
            public Matrix t(Matrix var1);

            public Matrix inverse(Matrix var1);

            public DoubleSeq solveLx(Matrix var1, DoubleSeq var2);

            public DoubleSeq solvexL(Matrix var1, DoubleSeq var2);
        }
    }

    public static final class Symmetric {
        private static final MatrixOperationsLoader.SymmetricComputer COMPUTER = new MatrixOperationsLoader.SymmetricComputer();

        public static void setComputer(SymmetricComputer computer) {
            COMPUTER.set(computer);
        }

        public static SymmetricComputer getComputer() {
            return COMPUTER.get();
        }

        public static Matrix t(Matrix L) {
            return Symmetric.getComputer().t(L);
        }

        public static Matrix XXt(Matrix X) {
            return Symmetric.getComputer().XXt(X);
        }

        public static Matrix XtX(Matrix X) {
            return Symmetric.getComputer().XtX(X);
        }

        public static Matrix xSx(Matrix S, DoubleSeq x) {
            return Symmetric.getComputer().xSx(S, x);
        }

        public static Matrix XSXt(Matrix S, Matrix X) {
            return Symmetric.getComputer().XSXt(S, X);
        }

        public static Matrix XtSX(Matrix S, Matrix X) {
            return Symmetric.getComputer().XtSX(S, X);
        }

        public static Matrix lcholesky(Matrix M) {
            return Symmetric.getComputer().lcholesky(M);
        }

        public static Matrix ucholesky(Matrix M) {
            return Symmetric.getComputer().ucholesky(M);
        }

        public static Matrix inverse(Matrix M) {
            return Symmetric.getComputer().inverse(M);
        }

        @Generated
        private Symmetric() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        @InterchangeableProcessor
        public static interface SymmetricComputer {
            public Matrix t(Matrix var1);

            public Matrix xSx(Matrix var1, DoubleSeq var2);

            public Matrix XXt(Matrix var1);

            public Matrix XtX(Matrix var1);

            public Matrix XSXt(Matrix var1, Matrix var2);

            public Matrix XtSX(Matrix var1, Matrix var2);

            public Matrix lcholesky(Matrix var1);

            public Matrix ucholesky(Matrix var1);

            public Matrix inverse(Matrix var1);
        }
    }
}

