## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(distionary)

## -----------------------------------------------------------------------------
d1 <- dst_geom(0.6)
eval_pmf(d1, at = 0:5)

## -----------------------------------------------------------------------------
enframe_pmf(d1, at = 0:5)

## -----------------------------------------------------------------------------
d2 <- dst_geom(0.4)
enframe_pmf(
  model1 = d1, model2 = d2, at = 0:5,
  arg_name = "num_failures", fn_prefix = "probability"
)

## -----------------------------------------------------------------------------
set.seed(42)
realise(d1, n = 5)

## -----------------------------------------------------------------------------
realise(d1)

## -----------------------------------------------------------------------------
mean(d1)
variance(d1)

