/*
 * Decompiled with CFR 0.152.
 */
package com.visutools.nav.bislider;

import java.awt.Color;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.text.html.parser.ParserDelegator;

public class BiSliderAbstraction
implements Serializable {
    protected static final ParserDelegator MAXIMUM_VARIABLE_SIZE_FOR_NAME = null;
    static final long serialVersionUID = 4827806780191894336L;
    int MinimumValue = 0;
    int MaximumValue = 100;
    int MinimumColoredValue = this.MinimumValue;
    int MaximumColoredValue = this.MaximumValue;
    int SegmentCount = 10;
    double SegmentSize = 10.0;
    Color SliderBackground = SystemColor.scrollbar;
    Color DefaultColor = Color.WHITE;
    Color MinimumColor = Color.RED;
    Color MiddleColor = Color.WHITE;
    Color MaximumColor = Color.BLUE;
    String Unit = "";
    boolean UniformSegment = false;
    int ArcSize = 0;
    boolean Sound = false;
    boolean Precise = false;
    String InterpolationMode = "CENTRAL";

    public void setSegmentSize(double SegmentSize_Arg) {
        this.SegmentSize = SegmentSize_Arg;
        this.SegmentCount = (int)Math.ceil((double)(this.MaximumValue - this.MinimumValue) / SegmentSize_Arg);
    }

    public int searchSegmentCount(int DesiredSegmentCount_Arg) {
        if (DesiredSegmentCount_Arg < 1 || this.MaximumValue - this.MinimumValue != this.MaximumValue - this.MinimumValue) {
            return 1;
        }
        if (DesiredSegmentCount_Arg > this.MaximumValue - this.MinimumValue) {
            return this.MaximumValue - this.MinimumValue;
        }
        if ((this.MaximumValue - this.MinimumValue) % DesiredSegmentCount_Arg == 0) {
            return DesiredSegmentCount_Arg;
        }
        int i = 1;
        while (DesiredSegmentCount_Arg - i > 1 || DesiredSegmentCount_Arg + i < (this.MaximumValue - this.MinimumValue) / 2) {
            if (DesiredSegmentCount_Arg - i > 1 && (this.MaximumValue - this.MinimumValue) % (DesiredSegmentCount_Arg - i) == 0) {
                return DesiredSegmentCount_Arg - i;
            }
            if (DesiredSegmentCount_Arg + i < (this.MaximumValue - this.MinimumValue) / 2 && (this.MaximumValue - this.MinimumValue) % (DesiredSegmentCount_Arg + i) == 0) {
                return DesiredSegmentCount_Arg + i;
            }
            ++i;
        }
        return 1;
    }

    public double[][] getColorTable() {
        if (this.SegmentCount == 1) {
            double[][] ColorTable = new double[1][4];
            ColorTable[0][0] = this.MinimumColoredValue;
            ColorTable[0][1] = this.MaximumColoredValue;
            ColorTable[0][2] = this.MinimumColor.getRGB();
            ColorTable[0][3] = 0.0;
            return ColorTable;
        }
        float Portion = 1.0f / (float)(this.SegmentCount - 1);
        int Mini = (int)Math.floor((double)(this.MinimumColoredValue - this.MinimumValue) / this.SegmentSize);
        int Maxi = (int)Math.ceil((double)(this.MaximumColoredValue - this.MinimumValue) / this.SegmentSize);
        int SelectedSegmentCount = Maxi - Mini;
        if (SelectedSegmentCount <= 0) {
            SelectedSegmentCount = 1;
        }
        double[][] ColorTable = new double[SelectedSegmentCount][4];
        for (int i = Mini; i < Maxi; ++i) {
            ColorTable[i - Mini][0] = (double)this.MinimumValue + this.SegmentSize * (double)i;
            ColorTable[i - Mini][1] = (double)this.MinimumValue + this.SegmentSize * (double)(i + 1);
            ColorTable[i - Mini][3] = i;
            Color NewColor = this.MinimumColor;
            if (this.InterpolationMode.equals("RGB")) {
                float dR = (float)(this.MaximumColor.getRed() - this.MinimumColor.getRed()) * Portion;
                float dG = (float)(this.MaximumColor.getGreen() - this.MinimumColor.getGreen()) * Portion;
                float dB = (float)(this.MaximumColor.getBlue() - this.MinimumColor.getBlue()) * Portion;
                try {
                    NewColor = new Color((int)((float)this.MinimumColor.getRed() + (float)i * dR), (int)((float)this.MinimumColor.getGreen() + (float)i * dG), (int)((float)this.MinimumColor.getBlue() + (float)i * dB));
                }
                catch (IllegalArgumentException IllegalArgumentException_Arg) {
                    System.err.println("Error for i=" + i + "dRGB=" + dR + "," + dG + "," + dB + ":" + this.MinimumColor + ":" + this.SegmentSize + ":" + this.SegmentCount);
                    IllegalArgumentException_Arg.printStackTrace();
                }
            } else if (this.InterpolationMode.equals("HSB")) {
                float[] hsb0 = Color.RGBtoHSB(this.MinimumColor.getRed(), this.MinimumColor.getGreen(), this.MinimumColor.getBlue(), null);
                float[] hsb1 = Color.RGBtoHSB(this.MaximumColor.getRed(), this.MaximumColor.getGreen(), this.MaximumColor.getBlue(), null);
                float dh = (hsb1[0] - hsb0[0]) * Portion;
                float ds = (hsb1[1] - hsb0[1]) * Portion;
                float db = (hsb1[2] - hsb0[2]) * Portion;
                NewColor = Color.getHSBColor(hsb0[0] + dh * (float)i, hsb0[1] + ds * (float)i, hsb0[2] + db * (float)i);
            } else if (this.InterpolationMode.equals("CENTRAL")) {
                Portion = 2.0f / (float)(this.SegmentCount - 1);
                float Portion2 = 2.0f / (float)this.SegmentCount;
                float dR1 = (float)(this.MaximumColor.getRed() - this.MiddleColor.getRed()) * Portion;
                float dG1 = (float)(this.MaximumColor.getGreen() - this.MiddleColor.getGreen()) * Portion;
                float dB1 = (float)(this.MaximumColor.getBlue() - this.MiddleColor.getBlue()) * Portion;
                float dR2 = (float)(this.MiddleColor.getRed() - this.MinimumColor.getRed()) * Portion2;
                float dG2 = (float)(this.MiddleColor.getGreen() - this.MinimumColor.getGreen()) * Portion2;
                float dB2 = (float)(this.MiddleColor.getBlue() - this.MinimumColor.getBlue()) * Portion2;
                if (this.SegmentCount == 2 && i == 0) {
                    NewColor = this.MinimumColor;
                } else if (this.SegmentCount == 2 && i == 1) {
                    NewColor = this.MaximumColor;
                } else if (i > this.SegmentCount / 2) {
                    int k = i - this.SegmentCount / 2;
                    try {
                        NewColor = new Color((int)((float)this.MiddleColor.getRed() + (float)k * dR1), (int)((float)this.MiddleColor.getGreen() + (float)k * dG1), (int)((float)this.MiddleColor.getBlue() + (float)k * dB1));
                    }
                    catch (Exception Exception_Arg) {
                        Exception_Arg.printStackTrace();
                        System.out.println("error1 with ");
                        System.out.println("  SegmentCount = " + this.SegmentCount);
                        System.out.println("  dR1 = " + dR1);
                        System.out.println("  dG1 = " + dG1);
                        System.out.println("  dB1 = " + dB1);
                        System.out.println("  Portion = " + Portion);
                        System.out.println("  i = " + i);
                        NewColor = Color.WHITE;
                    }
                } else {
                    try {
                        NewColor = new Color((int)((float)this.MinimumColor.getRed() + (float)i * dR2), (int)((float)this.MinimumColor.getGreen() + (float)i * dG2), (int)((float)this.MinimumColor.getBlue() + (float)i * dB2));
                    }
                    catch (Exception Exception_Arg) {
                        Exception_Arg.printStackTrace();
                        System.out.println("error2 with ");
                        System.out.println("  SegmentCount = " + this.SegmentCount);
                        System.out.println("  dR2 = " + dR2);
                        System.out.println("  dG2 = " + dG2);
                        System.out.println("  dB2 = " + dB2);
                        System.out.println("  Portion = " + Portion);
                        NewColor = Color.WHITE;
                    }
                }
            }
            ColorTable[i - Mini][2] = NewColor.getRGB();
        }
        if (ColorTable[0][0] != (double)this.MinimumColoredValue) {
            ColorTable[0][0] = this.MinimumColoredValue;
        }
        if (ColorTable[SelectedSegmentCount - 1][1] != (double)this.MaximumColoredValue) {
            ColorTable[SelectedSegmentCount - 1][1] = this.MaximumColoredValue;
        }
        return ColorTable;
    }

    public String toString() {
        double[][] ColorArray = this.getColorTable();
        StringBuffer SB1 = new StringBuffer();
        SB1.append("Color table with " + ColorArray.length + " segments\n");
        SB1.append("MinimumValue        = " + this.MinimumValue + "\n");
        SB1.append("MinimumColoredValue = " + this.MinimumColoredValue + "\n");
        SB1.append("MaximumColoredValue = " + this.MaximumColoredValue + "\n");
        SB1.append("MaximumValue        = " + this.MaximumValue + "\n");
        SB1.append("SegmentSize         = " + this.SegmentSize + "\n");
        SB1.append("SegmentCount        = " + this.SegmentCount + "\n");
        for (int k = 0; k < ColorArray.length; ++k) {
            Color Color1 = new Color((int)ColorArray[k][2]);
            SB1.append(ColorArray[k][0] + "-->" + ColorArray[k][1] + " with R=" + Color1.getRed() + ", G=" + Color1.getGreen() + ", B=" + Color1.getBlue() + "\n");
        }
        SB1.append("\n");
        return SB1.toString();
    }
}

