## ----install-instructions, eval=FALSE-----------------------------------------
# install.packages("shinystate")

## ----app, eval=FALSE----------------------------------------------------------
# library(shiny)
# library(bslib)
# library(shinystate)
# 
# storage <- StorageClass$new()
# 
# ui <- function(request) {
#   page_sidebar(
#     title = "Basic App",
#     sidebar = sidebar(
#       accordion(
#         open = c("user_inputs", "state"),
#         accordion_panel(
#           id = "user_inputs",
#           "User Inputs",
#           textInput(
#             "txt",
#             label = "Enter Title",
#             placeholder = "change this"
#           ),
#           checkboxInput("caps", "Capitalize"),
#           sliderInput(
#             "bins",
#             label = "Number of bins",
#             min = 1,
#             max = 50,
#             value = 30
#           ),
#           actionButton("add", "Add")
#         ),
#         accordion_panel(
#           id = "state",
#           "Bookmark State",
#           actionButton("bookmark", "Bookmark"),
#           actionButton("restore", "Restore Last Bookmark")
#         )
#       )
#     ),
#     use_shinystate(),
#     card(
#       card_header("App Output"),
#       plotOutput("distPlot")
#     )
#   )
# }
# 
# server <- function(input, output, session) {
#   storage$register_metadata()
# 
#   vals <- reactiveValues(sum = 0)
# 
#   plot_title <- reactive({
#     if (!shiny::isTruthy(input$txt)) {
#       value <- "Default Title"
#     } else {
#       value <- input$txt
#     }
# 
#     if (input$caps) {
#       value <- toupper(value)
#     }
# 
#     return(value)
#   })
# 
#   onBookmark(function(state) {
#     state$values$currentSum <- vals$sum
#   })
# 
#   onRestore(function(state) {
#     vals$sum <- state$values$currentSum
#   })
# 
#   observeEvent(input$add, {
#     vals$sum <- vals$sum + input$n
#   })
# 
#   output$distPlot <- renderPlot({
#     req(plot_title())
#     x <- faithful$waiting
#     bins <- seq(min(x), max(x), length.out = input$bins + 1)
#     hist(
#       x,
#       breaks = bins,
#       col = "#007bc2",
#       border = "white",
#       xlab = "Waiting time to next eruption (in mins)",
#       main = plot_title()
#     )
#   })
# 
#   observeEvent(input$bookmark, {
#     storage$snapshot()
#     showNotification("Session successfully saved")
#   })
# 
#   observeEvent(input$restore, {
#     session_df <- storage$get_sessions()
#     storage$restore(tail(session_df$url, n = 1))
#   })
# 
#   setBookmarkExclude(c("add", "bookmark", "restore"))
# }
# 
# shinyApp(ui, server, enableBookmarking = "server")

## ----shinylive_url, echo = FALSE, results = 'asis'----------------------------
code <- paste0(
  c(
    "webr::install('shinystate', repos = c('https://rpodcast.r-universe.dev', 'https://repo.r-wasm.org'))",
    knitr::knit_code$get("app")
  ),
  collapse = "\n"
)

url <- roxy.shinylive::create_shinylive_url(code)
cat(sprintf("[Open in Shinylive](%s)\n\n", url))

## ----shinylive_iframe, echo = FALSE, out.width = '150%', out.extra = 'style = "position: relative; z-index:1"', eval = knitr::is_html_output() && identical(Sys.getenv("IN_PKGDOWN"), "true")----
# knitr::include_url(url, height = "800px")
# 

