/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.converters.CSVDataConverter;
import org.vikamine.kernel.data.converters.CSVDataConverterConfig;
import org.vikamine.kernel.data.converters.GenericDataTable;
import org.vikamine.kernel.data.converters.GenericDataTableReader;
import org.vikamine.kernel.data.creators.ARFFDataOntologyCreator;
import org.vikamine.kernel.data.creators.AbstractOntologyCreator;

public class CSVDataOntologyCreator
extends AbstractOntologyCreator {
    public static final String EXTENSION = "csv";
    private final File file;
    private final CSVDataConverterConfig csvConfig;

    protected CSVDataOntologyCreator(File inputFile) {
        this.file = inputFile;
        this.csvConfig = CSVDataConverter.getStandardCsvConfiguration();
    }

    public CSVDataOntologyCreator(File inputFile, CSVDataConverterConfig csvConfiguration) throws IOException {
        this.file = inputFile;
        this.csvConfig = csvConfiguration;
        this.dataset = this.importInstancesFromCSVFile();
    }

    @Override
    public Ontology createOntology() {
        if (this.dataset == null) {
            throw new IllegalStateException("Dataset is null!");
        }
        Ontology ontology = new Ontology(this.dataset);
        this.createDatasetIDs();
        this.copyAttributesToOntology(ontology);
        ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILETYPE_PROPERTY, ".csv"));
        ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_NAME_PROPERTY, this.file.getName()));
        RDFStatement<Ontology, String> absolutePathStatement = new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_ABSOLUTE_PATH_PROPERTY, this.file.getAbsolutePath());
        ontology.getTripleStore().addStatement(absolutePathStatement);
        return ontology;
    }

    private static GenericDataTable getCSVTable(File file, char separator, char quote, char commentSymbol) throws IOException {
        return GenericDataTableReader.readTable(file, separator, quote, commentSymbol, true);
    }

    private DataRecordSet importInstancesFromCSVFile() throws IOException {
        DataRecordSet recordSet = null;
        try {
            recordSet = CSVDataConverter.process(CSVDataOntologyCreator.getCSVTable(this.file, this.csvConfig.separator, this.csvConfig.quote, this.csvConfig.comment), this.csvConfig.numberFormat, this.file.getName());
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger(ARFFDataOntologyCreator.class.getName()).throwing(ARFFDataOntologyCreator.class.getName(), "File not found: " + this.file, fnfex);
            throw new IOException(fnfex);
        }
        catch (IOException ioex) {
            Logger.getLogger(ARFFDataOntologyCreator.class.getName()).throwing(ARFFDataOntologyCreator.class.getName(), "Problem with csv format of: " + this.file, ioex);
            throw ioex;
        }
        return recordSet;
    }
}

