/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.set.PropAllDiff;
import org.chocosolver.solver.constraints.set.PropAllDisjoint;
import org.chocosolver.solver.constraints.set.PropAllEqual;
import org.chocosolver.solver.constraints.set.PropAtMost1Empty;
import org.chocosolver.solver.constraints.set.PropBoolChannel;
import org.chocosolver.solver.constraints.set.PropElement;
import org.chocosolver.solver.constraints.set.PropIntBoundedMemberSet;
import org.chocosolver.solver.constraints.set.PropIntChannel;
import org.chocosolver.solver.constraints.set.PropIntCstMemberSet;
import org.chocosolver.solver.constraints.set.PropIntCstNotMemberSet;
import org.chocosolver.solver.constraints.set.PropIntEnumMemberSet;
import org.chocosolver.solver.constraints.set.PropIntersection;
import org.chocosolver.solver.constraints.set.PropIntersectionFilterSets;
import org.chocosolver.solver.constraints.set.PropInverse;
import org.chocosolver.solver.constraints.set.PropMaxElement;
import org.chocosolver.solver.constraints.set.PropMinElement;
import org.chocosolver.solver.constraints.set.PropNbEmpty;
import org.chocosolver.solver.constraints.set.PropNotEmpty;
import org.chocosolver.solver.constraints.set.PropNotMemberIntSet;
import org.chocosolver.solver.constraints.set.PropNotMemberSetInt;
import org.chocosolver.solver.constraints.set.PropOffSet;
import org.chocosolver.solver.constraints.set.PropSetIntValuesUnion;
import org.chocosolver.solver.constraints.set.PropSubsetEq;
import org.chocosolver.solver.constraints.set.PropSumOfElements;
import org.chocosolver.solver.constraints.set.PropSymmetric;
import org.chocosolver.solver.constraints.set.PropUnion;
import org.chocosolver.solver.constraints.set.PropUnionVar;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public interface ISetConstraintFactory
extends ISelf<Model> {
    default public Constraint union(IntVar[] ints, SetVar union) {
        return new Constraint("SETINTVALUESUNION", new PropSetIntValuesUnion(ints, union), new PropSetIntValuesUnion(ints, union));
    }

    default public Constraint union(SetVar[] sets, SetVar unionSet) {
        return new Constraint("SETUNION", new PropUnion(sets, unionSet), new PropUnion(sets, unionSet));
    }

    default public Constraint union(SetVar unionSet, int vOffset, SetVar indices, int iOffset, SetVar[] sets) {
        return new Constraint("SETUNION", new PropUnionVar(unionSet, vOffset, indices, iOffset, sets));
    }

    default public Constraint union(SetVar unionSet, SetVar indices, SetVar[] sets) {
        return this.union(unionSet, 0, indices, 0, sets);
    }

    default public Constraint intersection(SetVar[] sets, SetVar intersectionSet) {
        return this.intersection(sets, intersectionSet, false);
    }

    default public Constraint intersection(SetVar[] sets, SetVar intersectionSet, boolean boundConsistent) {
        if (sets.length == 0) {
            throw new IllegalArgumentException("The intersection of zero sets is undefined.");
        }
        if (boundConsistent) {
            return new Constraint("SETINTERSECTION", new PropIntersection(sets, intersectionSet), sets.length == 1 ? new PropAllEqual(new SetVar[]{sets[0], intersectionSet}) : new PropIntersectionFilterSets(sets, intersectionSet));
        }
        return new Constraint("SETINTERSECTION", new PropIntersection(sets, intersectionSet));
    }

    default public Constraint subsetEq(SetVar ... sets) {
        Propagator[] props = new Propagator[sets.length - 1];
        for (int i = 0; i < sets.length - 1; ++i) {
            props[i] = new PropSubsetEq(sets[i], sets[i + 1]);
        }
        return new Constraint("SETSUBSETEQ", props);
    }

    default public Constraint nbEmpty(SetVar[] sets, int nbEmpty) {
        return this.nbEmpty(sets, ((Model)this.ref()).intVar(nbEmpty));
    }

    default public Constraint nbEmpty(SetVar[] sets, IntVar nbEmpty) {
        return new Constraint("SETNBEMPTY", new PropNbEmpty(sets, nbEmpty));
    }

    default public Constraint offSet(SetVar set1, SetVar set2, int offset) {
        return new Constraint("SETOFFSET", new PropOffSet(set1, set2, offset));
    }

    default public Constraint notEmpty(SetVar set) {
        return new Constraint("SETNOTEMPTY", new PropNotEmpty(set));
    }

    default public Constraint sum(SetVar set, IntVar sum) {
        return this.sumElements(set, null, 0, sum);
    }

    default public Constraint sumElements(SetVar indices, int[] weights, IntVar sum) {
        return this.sumElements(indices, weights, 0, sum);
    }

    default public Constraint sumElements(SetVar indices, int[] weights, int offset, IntVar sum) {
        return new Constraint("SETSUM", new PropSumOfElements(indices, weights, offset, sum));
    }

    default public Constraint max(SetVar set, IntVar maxElementValue, boolean notEmpty) {
        return this.max(set, null, 0, maxElementValue, notEmpty);
    }

    default public Constraint max(SetVar indices, int[] weights, int offset, IntVar maxElementValue, boolean notEmpty) {
        if (notEmpty) {
            return new Constraint("SETMAX", new PropNotEmpty(indices), new PropMaxElement(indices, weights, offset, maxElementValue, true));
        }
        return new Constraint("SETMAX", new PropMaxElement(indices, weights, offset, maxElementValue, false));
    }

    default public Constraint min(SetVar set, IntVar minElementValue, boolean notEmpty) {
        return this.min(set, null, 0, minElementValue, notEmpty);
    }

    default public Constraint min(SetVar indices, int[] weights, int offset, IntVar minElementValue, boolean notEmpty) {
        if (notEmpty) {
            return new Constraint("SETMIN", new PropNotEmpty(indices), new PropMinElement(indices, weights, offset, minElementValue, true));
        }
        return new Constraint("SETMIN", new PropMinElement(indices, weights, offset, minElementValue, false));
    }

    default public Constraint setBoolsChanneling(BoolVar[] bools, SetVar set) {
        return this.setBoolsChanneling(bools, set, 0);
    }

    default public Constraint setBoolsChanneling(BoolVar[] bools, SetVar set, int offset) {
        return new Constraint("SETBOOLCHANNELING", new PropBoolChannel(set, bools, offset));
    }

    default public Constraint setsIntsChanneling(SetVar[] sets, IntVar[] ints) {
        return this.setsIntsChanneling(sets, ints, 0, 0);
    }

    default public Constraint setsIntsChanneling(SetVar[] sets, IntVar[] ints, int offset1, int offset2) {
        return new Constraint("SETINTCHANNELING", new PropIntChannel(sets, ints, offset1, offset2), new PropIntChannel(sets, ints, offset1, offset2), new PropAllDisjoint(sets));
    }

    default public Constraint disjoint(SetVar set1, SetVar set2) {
        return this.allDisjoint(set1, set2);
    }

    default public Constraint allDisjoint(SetVar ... sets) {
        return new Constraint("SETALLDISJOINT", new PropAllDisjoint(sets));
    }

    default public Constraint allDifferent(SetVar ... sets) {
        return new Constraint("SETALLDIFFERENT", new PropAllDiff(sets), new PropAllDiff(sets), new PropAtMost1Empty(sets));
    }

    default public Constraint allEqual(SetVar ... sets) {
        return new Constraint("SETALLEQUAL", new PropAllEqual(sets));
    }

    default public Constraint partition(SetVar[] sets, SetVar universe) {
        Constraint allDisjoint = this.allDisjoint(sets);
        allDisjoint.ignore();
        return new Constraint("SETPARTITION", ArrayUtils.append(allDisjoint.getPropagators(), {new PropUnion(sets, universe), new PropUnion(sets, universe)}));
    }

    default public Constraint inverseSet(SetVar[] sets, SetVar[] invSets, int offset1, int offset2) {
        return new Constraint("SETINVERSE", new PropInverse(sets, invSets, offset1, offset2));
    }

    default public Constraint symmetric(SetVar ... sets) {
        return this.symmetric(sets, 0);
    }

    default public Constraint symmetric(SetVar[] sets, int offset) {
        return new Constraint("SETSYMMETRIC", new PropSymmetric(sets, offset));
    }

    default public Constraint element(IntVar index, SetVar[] sets, SetVar set) {
        return this.element(index, sets, 0, set);
    }

    default public Constraint element(IntVar index, SetVar[] sets, int offset, SetVar set) {
        return new Constraint("SETELEMENT", new PropElement(index, sets, offset, set), new PropElement(index, sets, offset, set));
    }

    default public Constraint member(SetVar[] sets, SetVar set) {
        IntVar index = ((Model)this.ref()).intVar("idx_tmp", 0, sets.length - 1, false);
        return this.element(index, sets, 0, set);
    }

    default public Constraint member(final IntVar intVar, final SetVar set) {
        if (intVar.isInstantiated()) {
            return this.member(intVar.getValue(), set);
        }
        return new Constraint("SETMEMBER", new Propagator[]{intVar.hasEnumeratedDomain() ? new PropIntEnumMemberSet(set, intVar) : new PropIntBoundedMemberSet(set, intVar)}){

            @Override
            public Constraint makeOpposite() {
                return ISetConstraintFactory.this.notMember(intVar, set);
            }
        };
    }

    default public Constraint member(final int cst, final SetVar set) {
        return new Constraint("SETMEMBER", new Propagator[]{new PropIntCstMemberSet(set, cst)}){

            @Override
            public Constraint makeOpposite() {
                return ISetConstraintFactory.this.notMember(cst, set);
            }
        };
    }

    default public Constraint notMember(final IntVar intVar, final SetVar set) {
        if (intVar.isInstantiated()) {
            return this.notMember(intVar.getValue(), set);
        }
        IntVar integer = intVar;
        if (!intVar.hasEnumeratedDomain()) {
            integer = ((Model)this.ref()).intVar("enumViewOf(" + intVar.getName() + ")", intVar.getLB(), intVar.getUB(), false);
            ((Model)this.ref()).arithm(integer, "=", intVar).post();
        }
        return new Constraint("SETNOTMEMBER", new Propagator[]{new PropNotMemberIntSet(integer, set), new PropNotMemberSetInt(integer, set)}){

            @Override
            public Constraint makeOpposite() {
                return ISetConstraintFactory.this.member(intVar, set);
            }
        };
    }

    default public Constraint notMember(final int cst, final SetVar set) {
        return new Constraint("SETNOTMEMBER", new Propagator[]{new PropIntCstNotMemberSet(set, cst)}){

            @Override
            public Constraint makeOpposite() {
                return ISetConstraintFactory.this.member(cst, set);
            }
        };
    }

    default public Constraint setLe(SetVar a2, SetVar b) {
        int v;
        IntIterableRangeSet union = new IntIterableRangeSet();
        ISetIterator iSetIterator = a2.getUB().iterator();
        while (iSetIterator.hasNext()) {
            v = (Integer)iSetIterator.next();
            union.add(v);
        }
        iSetIterator = b.getUB().iterator();
        while (iSetIterator.hasNext()) {
            v = (Integer)iSetIterator.next();
            union.add(v);
        }
        return ((Model)this.ref()).lexLessEq(((Model)this.ref()).setBoolsView(a2, union.size(), union.min()), ((Model)this.ref()).setBoolsView(b, union.size(), union.min()));
    }

    default public Constraint setLt(SetVar a2, SetVar b) {
        int v;
        IntIterableRangeSet union = new IntIterableRangeSet();
        ISetIterator iSetIterator = a2.getUB().iterator();
        while (iSetIterator.hasNext()) {
            v = (Integer)iSetIterator.next();
            union.add(v);
        }
        iSetIterator = b.getUB().iterator();
        while (iSetIterator.hasNext()) {
            v = (Integer)iSetIterator.next();
            union.add(v);
        }
        return ((Model)this.ref()).lexLess(((Model)this.ref()).setBoolsView(a2, union.size(), union.min()), ((Model)this.ref()).setBoolsView(b, union.size(), union.min()));
    }
}

