/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.TransformerEncoder;

public class PreProcessEncoder
extends TransformerEncoder<RGenericVector> {
    private Map<String, List<Double>> ranges = Collections.emptyMap();
    private Map<String, Double> mean = Collections.emptyMap();
    private Map<String, Double> std = Collections.emptyMap();
    private Map<String, Double> median = Collections.emptyMap();

    public PreProcessEncoder(RGenericVector preProcess) {
        super(preProcess);
        RGenericVector method = preProcess.getGenericElement("method");
        RStringVector methodNames = method.names();
        block14: for (int i = 0; i < methodNames.size(); ++i) {
            String methodName;
            switch (methodName = methodNames.getValue(i)) {
                case "ignore": {
                    continue block14;
                }
                case "range": {
                    this.ranges = PreProcessEncoder.createArguments(preProcess.getDoubleElement("ranges"), 2);
                    continue block14;
                }
                case "center": {
                    this.mean = PreProcessEncoder.createArguments(preProcess.getDoubleElement("mean"));
                    continue block14;
                }
                case "scale": {
                    this.std = PreProcessEncoder.createArguments(preProcess.getDoubleElement("std"));
                    continue block14;
                }
                case "medianImpute": {
                    this.median = PreProcessEncoder.createArguments(preProcess.getDoubleElement("median"));
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException(methodName);
                }
            }
        }
    }

    @Override
    public void addFeature(Feature feature) {
        Expression transformedExpression;
        FieldRef expression;
        String name = FeatureUtil.getName((Feature)feature);
        DataField dataField = this.getDataField(name);
        if (dataField != null && !(expression = feature.ref()).equals(transformedExpression = this.encodeExpression(name, (Expression)expression))) {
            DerivedField derivedField = this.createDerivedField(FieldNameUtil.create((String)"preProcess", (Object[])new Object[]{feature}), OpType.CONTINUOUS, DataType.DOUBLE, transformedExpression);
            feature = new ContinuousFeature((PMMLEncoder)this, (Field)derivedField);
        }
        super.addFeature(feature);
    }

    private Expression encodeExpression(String name, Expression expression) {
        Double median;
        Double std;
        Double mean;
        List<Double> ranges = this.ranges.get(name);
        if (ranges != null) {
            Double min = ranges.get(0);
            Double max = ranges.get(1);
            if (!ValueUtil.isZero((Number)min)) {
                expression = ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)min)});
            }
            if (!ValueUtil.isOne((Number)(max - min))) {
                expression = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)(max - min))});
            }
        }
        if ((mean = this.mean.get(name)) != null && !ValueUtil.isZero((Number)mean)) {
            expression = ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)mean)});
        }
        if ((std = this.std.get(name)) != null && !ValueUtil.isOne((Number)std)) {
            expression = ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)std)});
        }
        if ((median = this.median.get(name)) != null) {
            expression = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{new FieldRef(name)}), expression, ExpressionUtil.createConstant((Number)median)});
        }
        return expression;
    }

    private static Map<String, Double> createArguments(RDoubleVector values) {
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        RStringVector names = values.names();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.getValue(i);
            result.put(name, values.getValue(i));
        }
        return result;
    }

    private static Map<String, List<Double>> createArguments(RDoubleVector values, int rows) {
        LinkedHashMap<String, List<Double>> result = new LinkedHashMap<String, List<Double>>();
        RStringVector rowNames = values.dimnames(0);
        RStringVector columnNames = values.dimnames(1);
        for (int i = 0; i < columnNames.size(); ++i) {
            String name = columnNames.getValue(i);
            result.put(name, FortranMatrixUtil.getColumn(values.getValues(), (int)rows, (int)columnNames.size(), (int)i));
        }
        return result;
    }
}

