/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.randvar.BetaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaStratifiedRejectionGen
extends BetaGen {
    private RandomStream auxStream;
    private int gen;
    private static final int b00 = 2;
    private static final int b01 = 3;
    private static final int b01inv = 4;
    private static final int b1prs = 5;
    private double pint;
    private double qint;
    private double p_;
    private double q_;
    private double c;
    private double t;
    private double fp;
    private double fq;
    private double ml;
    private double mu;
    private double p1;
    private double p2;
    private double s;
    private double m;
    private double D;
    private double Dl;
    private double x1;
    private double x2;
    private double x4;
    private double x5;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double ll;
    private double lr;
    private double z2;
    private double z4;
    private double p3;
    private double p4;

    public BetaStratifiedRejectionGen(RandomStream randomStream, RandomStream randomStream2, BetaDist betaDist) {
        super(randomStream, betaDist);
        this.auxStream = randomStream2;
        this.init();
    }

    public BetaStratifiedRejectionGen(RandomStream randomStream, BetaDist betaDist) {
        this(randomStream, randomStream, betaDist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    public double nextDouble() {
        double d = 0.0;
        RandomStream randomStream = this.stream;
        block0 : switch (this.gen) {
            case 2: {
                while (true) {
                    double d2;
                    double d3;
                    double d4 = randomStream.nextDouble() * this.p2;
                    randomStream = this.auxStream;
                    if (d4 <= this.p1) {
                        d3 = Math.exp(Math.log(d4 / this.p1) / this.p);
                        d = this.t * d3;
                        d2 = randomStream.nextDouble() * this.fq;
                        if (!(d2 <= 1.0 - this.q_ * d) && (!(d2 <= 1.0 + (this.fq - 1.0) * d3) || !(Math.log(d2) <= this.q_ * Math.log(1.0 - d)))) continue;
                        break block0;
                    }
                    d3 = Math.exp(Math.log((d4 - this.p1) / (this.p2 - this.p1)) / this.q);
                    d = 1.0 - (1.0 - this.t) * d3;
                    d2 = randomStream.nextDouble() * this.fp;
                    if (d2 <= 1.0 - this.p_ * (1.0 - d) || d2 <= 1.0 + (this.fp - 1.0) * d3 && Math.log(d2) <= this.p_ * Math.log(d)) break;
                }
                break;
            }
            case 3: 
            case 4: {
                while (true) {
                    double d5;
                    double d6;
                    double d7 = randomStream.nextDouble() * this.p2;
                    randomStream = this.auxStream;
                    if (d7 <= this.p1) {
                        d6 = Math.exp(Math.log(d7 / this.p1) / this.pint);
                        d = this.t * d6;
                        d5 = randomStream.nextDouble();
                        if (!(d5 <= 1.0 - this.ml * d) && (!(d5 <= 1.0 - this.mu * d6) || !(Math.log(d5) <= this.q_ * Math.log(1.0 - d)))) continue;
                        break;
                    }
                    d6 = Math.exp(Math.log((d7 - this.p1) / (this.p2 - this.p1)) / this.qint);
                    d = 1.0 - (1.0 - this.t) * d6;
                    d5 = randomStream.nextDouble() * this.fp;
                    if (d5 <= 1.0 - this.p_ * (1.0 - d) || d5 <= 1.0 + (this.fp - 1.0) * d6 && Math.log(d5) <= this.p_ * Math.log(d)) break;
                }
                if (!(this.p > this.q)) break;
                d = 1.0 - d;
                break;
            }
            case 5: {
                while (true) {
                    double d8;
                    double d9;
                    double d10;
                    double d11 = randomStream.nextDouble() * this.p4;
                    randomStream = this.auxStream;
                    if (d11 <= this.p1) {
                        d10 = d11 / this.Dl - this.f2;
                        if (d10 <= 0.0) {
                            d = this.m - d11 / this.f2;
                            break block0;
                        }
                        if (d10 <= this.f1) {
                            d = this.x2 - d10 / this.f1 * this.Dl;
                            break block0;
                        }
                        d11 = randomStream.nextDouble();
                        d9 = this.Dl * d11;
                        d = this.x2 - d9;
                        d8 = this.x2 + d9;
                        if (d10 * (this.x2 - this.z2) <= this.f2 * (d - this.z2)) break block0;
                        d9 = this.f2 + this.f2 - d10;
                        if (d9 < 1.0) {
                            if (d9 <= this.f2 + (1.0 - this.f2) * d11) {
                                d = d8;
                                break block0;
                            }
                            if (d9 <= Math.exp(this.p_ * Math.log(d8 / this.m) + this.q_ * Math.log((10.0 - d8) / (1.0 - this.m)))) {
                                d = d8;
                                break block0;
                            }
                        }
                    } else if (d11 <= this.p2) {
                        d10 = (d11 -= this.p1) / this.D - this.f4;
                        if (d10 <= 0.0) {
                            d = this.m + d11 / this.f4;
                            break block0;
                        }
                        if (d10 <= this.f5) {
                            d = this.x4 + d10 / this.f5 * this.D;
                            break block0;
                        }
                        d11 = randomStream.nextDouble();
                        d9 = this.D * d11;
                        d = this.x4 + d9;
                        d8 = this.x4 - d9;
                        if (d10 * (this.z4 - this.x4) <= this.f4 * (this.z4 - d)) break block0;
                        d9 = this.f4 + this.f4 - d10;
                        if (d9 < 1.0) {
                            if (d9 <= this.f4 + (1.0 - this.f4) * d11) {
                                d = d8;
                                break block0;
                            }
                            if (d9 <= Math.exp(this.p_ * Math.log(d8 / this.m) + this.q_ * Math.log((1.0 - d8) / (1.0 - this.m)))) {
                                d = d8;
                                break block0;
                            }
                        }
                    } else if (d11 <= this.p3) {
                        d8 = Math.log(d11 = (d11 - this.p2) / (this.p3 - this.p2));
                        d = this.x1 + this.ll * d8;
                        if (d <= 0.0) continue;
                        d10 = d11 * randomStream.nextDouble();
                        if (d10 <= 1.0 + d8) break block0;
                        d10 *= this.f1;
                    } else {
                        d8 = Math.log(d11 = (d11 - this.p3) / (this.p4 - this.p3));
                        d = this.x5 - this.lr * d8;
                        if (d >= 1.0) continue;
                        d10 = d11 * randomStream.nextDouble();
                        if (d10 <= 1.0 + d8) break block0;
                        d10 *= this.f5;
                    }
                    if (Math.log(d10) <= this.p_ * Math.log(d / this.m) + this.q_ * Math.log((1.0 - d) / (1.0 - this.m))) break;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.gen == 4 ? this.a + (this.b - this.a) * (1.0 - d) : this.a + (this.b - this.a) * d;
    }

    public static double nextDouble(RandomStream randomStream, double d, double d2, double d3, double d4) {
        return BetaDist.inverseF(d, d2, d3, d4, 15, randomStream.nextDouble());
    }

    private void init() {
        BetaDist betaDist = (BetaDist)this.dist;
        this.p = betaDist.getAlpha();
        this.q = betaDist.getBeta();
        if (this.p > 1.0) {
            if (this.q > 1.0) {
                this.gen = 5;
            } else {
                this.gen = 4;
                this.p = betaDist.getBeta();
                this.q = betaDist.getAlpha();
            }
        } else {
            this.gen = this.q > 1.0 ? 3 : 2;
        }
        switch (this.gen) {
            case 2: {
                this.p_ = this.p - 1.0;
                this.q_ = this.q - 1.0;
                this.c = this.q * this.q_ / (this.p * this.p_);
                this.t = this.c == 1.0 ? 0.5 : (1.0 - Math.sqrt(this.c)) / (1.0 - this.c);
                this.fp = Math.exp(this.p_ * Math.log(this.t));
                this.fq = Math.exp(this.q_ * Math.log(1.0 - this.t));
                this.p1 = this.t / this.p;
                this.p2 = (1.0 - this.t) / this.q + this.p1;
                break;
            }
            case 3: 
            case 4: {
                if (this.p > this.q) {
                    this.pint = this.q;
                    this.qint = this.p;
                } else {
                    this.pint = this.p;
                    this.qint = this.q;
                }
                this.p_ = this.pint - 1.0;
                this.q_ = this.qint - 1.0;
                this.t = this.p_ / (this.pint - this.qint);
                this.fq = Math.exp((this.q_ - 1.0) * Math.log(1.0 - this.t));
                this.fp = this.pint - (this.pint + this.q_) * this.t;
                this.t -= (this.t - (1.0 - this.fp) * (1.0 - this.t) * this.fq / this.qint) / (1.0 - this.fp * this.fq);
                this.fp = Math.exp(this.p_ * Math.log(this.t));
                this.fq = Math.exp(this.q_ * Math.log(1.0 - this.t));
                if (this.q_ <= 1.0) {
                    this.ml = (1.0 - this.fq) / this.t;
                    this.mu = this.q_ * this.t;
                } else {
                    this.ml = this.q_;
                    this.mu = 1.0 - this.fq;
                }
                this.p1 = this.t / this.pint;
                this.p2 = this.fq * (1.0 - this.t) / this.qint + this.p1;
                break;
            }
            case 5: {
                this.p_ = this.p - 1.0;
                this.q_ = this.q - 1.0;
                this.s = this.p_ + this.q_;
                this.m = this.p_ / this.s;
                if (this.p_ > 1.0 || this.q_ > 1.0) {
                    this.D = Math.sqrt(this.m * (1.0 - this.m) / (this.s - 1.0));
                }
                if (this.p_ <= 1.0) {
                    this.x2 = this.Dl = this.m * 0.5;
                    this.ll = 0.0;
                    this.f1 = 0.0;
                    this.z2 = 0.0;
                    this.x1 = 0.0;
                } else {
                    this.x2 = this.m - this.D;
                    this.x1 = this.x2 - this.D;
                    this.z2 = this.x2 * (1.0 - (1.0 - this.x2) / (this.s * this.D));
                    if (this.x1 <= 0.0 || (this.s - 6.0) * this.x2 - this.p_ + 3.0 > 0.0) {
                        this.x1 = this.z2;
                        this.x2 = (this.x1 + this.m) * 0.5;
                        this.Dl = this.m - this.x2;
                    } else {
                        this.Dl = this.D;
                    }
                    this.f1 = Math.exp(this.p_ * Math.log(this.x1 / this.m) + this.q_ * Math.log((1.0 - this.x1) / (1.0 - this.m)));
                    this.ll = this.x1 * (1.0 - this.x1) / (this.s * (this.m - this.x1));
                }
                this.f2 = Math.exp(this.p_ * Math.log(this.x2 / this.m) + this.q_ * Math.log((1.0 - this.x2) / (1.0 - this.m)));
                if (this.q_ <= 1.0) {
                    this.D = (1.0 - this.m) * 0.5;
                    this.x4 = 1.0 - this.D;
                    this.z4 = 1.0;
                    this.x5 = 1.0;
                    this.lr = 0.0;
                    this.f5 = 0.0;
                } else {
                    this.x4 = this.m + this.D;
                    this.x5 = this.x4 + this.D;
                    this.z4 = this.x4 * (1.0 + (1.0 - this.x4) / (this.s * this.D));
                    if (this.x5 >= 1.0 || (this.s - 6.0) * this.x4 - this.p_ + 3.0 < 0.0) {
                        this.x5 = this.z4;
                        this.x4 = (this.m + this.x5) * 0.5;
                        this.D = this.x4 - this.m;
                    }
                    this.f5 = Math.exp(this.p_ * Math.log(this.x5 / this.m) + this.q_ * Math.log((1.0 - this.x5) / (1.0 - this.m)));
                    this.lr = this.x5 * (1.0 - this.x5) / (this.s * (this.x5 - this.m));
                }
                this.f4 = Math.exp(this.p_ * Math.log(this.x4 / this.m) + this.q_ * Math.log((1.0 - this.x4) / (1.0 - this.m)));
                this.p1 = this.f2 * (this.Dl + this.Dl);
                this.p2 = this.f4 * (this.D + this.D) + this.p1;
                this.p3 = this.f1 * this.ll + this.p2;
                this.p4 = this.f5 * this.lr + this.p3;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean equalsDouble(double d, double d2) {
        if (d == d2) {
            return true;
        }
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        return Math.abs(d - d2) <= Math.min(d3, d4) * 2.220446049250313E-16;
    }
}

