## -----------------------------------------------------------------------------
library(GTRT)

## ----eval=FALSE---------------------------------------------------------------
# s <- circular::rcircularuniform(10) # Starting points of 10 arcs
# t <- circular::rcircularuniform(10) # End points of arcs
# e1 <- c(2,10,6,1,5) # Indices for the first arc in 5 pairs formed unsing above 10 arcs.
# e2 <- c(4,3,8,7,9) # Indices for the second arc in 5 pairs formed unsing above 10 arcs.
# nip.rcag(s,t,e1,e2)

## -----------------------------------------------------------------------------
x <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
theta <- ((2*atan(x))%%(2*pi)) ##LAR(1) model
rcagep.test(theta,0.05)

## ----eval=FALSE---------------------------------------------------------------
# cdf.rcag(1000)

## ----eval=FALSE---------------------------------------------------------------
# x <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
# theta <- ((2*atan(x))%%(2*pi)) ##LAR(1) model
# deg.rcag(theta)

## -----------------------------------------------------------------------------
x <- arima.sim(model = list(ar=c(0.6,0.3)), 1000) ## AR(2) model
theta <- ((2*atan(x))%%(2*pi))*(180/pi) ##LAR(2) model
rcagdd.test(theta)

## ----eval=FALSE---------------------------------------------------------------
# thrsd.rcagdd(500,1000,0.05)

## -----------------------------------------------------------------------------
library(circular)
data(wind)
theta <- wind
rcagep.test(theta,0.05)

## -----------------------------------------------------------------------------
rcagdd.test(theta)

## -----------------------------------------------------------------------------
thrsd.rcagdd(length(theta),1000,c(0.05,0.01))

