/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.streamkm;

import com.yahoo.labs.samoa.instances.Instance;
import moa.cluster.Cluster;
import moa.cluster.SphereCluster;

public class Point {
    int dimension;
    double weight;
    double squareSum;
    double[] coordinates;
    double curCost;
    int centreIndex;
    int id;
    int cl;

    public Point(int dimension) {
        this.weight = 1.0;
        this.squareSum = 0.0;
        this.dimension = dimension;
        this.coordinates = new double[dimension];
        this.id = -1;
        this.cl = -1;
        this.curCost = 0.0;
        this.centreIndex = -1;
        for (int l = 0; l < dimension; ++l) {
            this.coordinates[l] = 0.0;
        }
    }

    public Point(Instance inst, int id) {
        this.weight = inst.weight();
        this.squareSum = 0.0;
        this.dimension = inst.numAttributes();
        this.coordinates = new double[this.dimension];
        this.id = id;
        this.cl = 0;
        this.curCost = 0.0;
        this.centreIndex = -1;
        for (int l = 0; l < this.dimension; ++l) {
            double nextNumber = inst.value(l) * inst.value(l);
            this.coordinates[l] = inst.value(l);
            this.squareSum += nextNumber * nextNumber;
        }
    }

    public Point clone() {
        Point res = new Point(this.dimension);
        res.weight = this.weight;
        res.squareSum = this.squareSum;
        res.dimension = this.dimension;
        res.coordinates = (double[])this.coordinates.clone();
        res.id = this.id;
        res.cl = this.cl;
        res.curCost = this.curCost;
        res.centreIndex = this.centreIndex;
        return res;
    }

    public Cluster toCluster(double radius) {
        double[] centre = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            centre[i] = this.coordinates[i] / this.weight;
        }
        return new SphereCluster(centre, radius, this.weight);
    }

    public double costOfPoint(int k, Point[] centres) {
        double nearestCost = -1.0;
        for (int j = 0; j < k; ++j) {
            double distance = 0.0;
            int l = 0;
            for (l = 0; l < this.dimension; ++l) {
                double centroidCoordinatePoint = this.weight != 0.0 ? this.coordinates[l] / this.weight : this.coordinates[l];
                double centroidCoordinateCentre = centres[j].weight != 0.0 ? centres[j].coordinates[l] / centres[j].weight : centres[j].coordinates[l];
                distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
            }
            if (!(nearestCost < 0.0) && !(distance < nearestCost)) continue;
            nearestCost = distance;
        }
        return this.weight * nearestCost;
    }

    public int determineClusterCentreKMeans(int k, Point[] centres) {
        int centre = 0;
        double nearestCost = -1.0;
        for (int j = 0; j < k; ++j) {
            double distance = 0.0;
            for (int l = 0; l < this.dimension; ++l) {
                double centroidCoordinatePoint = this.weight != 0.0 ? this.coordinates[l] / this.weight : this.coordinates[l];
                double centroidCoordinateCentre = centres[j].weight != 0.0 ? centres[j].coordinates[l] / centres[j].weight : centres[j].coordinates[l];
                distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
            }
            if (!(nearestCost < 0.0) && !(distance < nearestCost)) continue;
            nearestCost = distance;
            centre = j;
        }
        return centre;
    }

    public double costOfPointToCenter(Point centre) {
        if (this.weight == 0.0) {
            return 0.0;
        }
        double distance = 0.0;
        for (int l = 0; l < this.dimension; ++l) {
            double centroidCoordinatePoint = this.weight != 0.0 ? this.coordinates[l] / this.weight : this.coordinates[l];
            double centroidCoordinateCentre = centre.weight != 0.0 ? centre.coordinates[l] / centre.weight : centre.coordinates[l];
            distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
        }
        return distance * this.weight;
    }
}

