% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{str_like}
\alias{str_like}
\title{Detect a pattern in the same way as \code{SQL}'s \code{LIKE} operator}
\usage{
str_like(string, pattern, ignore_case = TRUE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{A character vector containing a SQL "like" pattern.
See above for details.}

\item{ignore_case}{Ignore case of matches? Defaults to \code{TRUE} to match
the SQL \code{LIKE} operator.}
}
\value{
A logical vector the same length as \code{string}.
}
\description{
\code{str_like()} follows the conventions of the SQL \code{LIKE} operator:
\itemize{
\item Must match the entire string.
\item \verb{_} matches a single character (like \code{.}).
\item \verb{\%} matches any number of characters (like \verb{.*}).
\item \verb{\\\%} and \verb{\\_} match literal \verb{\%} and \verb{_}.
\item The match is case insensitive by default.
}
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_like(fruit, "app")
str_like(fruit, "app\%")
str_like(fruit, "ba_ana")
str_like(fruit, "\%APPLE")
}
