/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.connectivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;

public class UGVarConnectivityHelper {
    private final UndirectedGraphVar g;
    private final int n;
    private final int[] fifo;
    private int numOrder;
    private final int[] num;
    private final BitSet visited;
    private final ISet articulationPoints = SetFactory.makeBipartiteSet(0);
    private final List<int[]> bridges = new ArrayList<int[]>();

    public UGVarConnectivityHelper(UndirectedGraphVar g) {
        this.g = g;
        this.n = g.getNbMaxNodes();
        this.fifo = new int[this.n];
        this.num = new int[this.n];
        this.visited = new BitSet(this.n);
    }

    public void exploreFrom(int root, BitSet visited) {
        int first = 0;
        int last = 0;
        int i = root;
        this.fifo[last++] = i;
        visited.set(i);
        while (first < last) {
            i = this.fifo[first++];
            ISetIterator iSetIterator = this.g.getPotentialNeighborsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (visited.get(j)) continue;
                visited.set(j);
                this.fifo[last++] = j;
            }
        }
    }

    public void computeMandatoryArticulationPointsAndBridges() {
        this.articulationPoints.clear();
        this.bridges.clear();
        ISet mNodes = this.g.getMandatoryNodes();
        if (this.g.getMandatoryNodes().size() < 2) {
            return;
        }
        this.visited.clear();
        Arrays.fill(this.num, 0);
        ISetIterator iSetIterator = mNodes.iterator();
        while (iSetIterator.hasNext()) {
            int root = (Integer)iSetIterator.next();
            if (this.visited.get(root)) continue;
            this.visited.set(root);
            this.computeMandatoryArticulationPointsAndBridgesFrom(root);
        }
    }

    private void computeMandatoryArticulationPointsAndBridgesFrom(int s) {
        assert (this.g.getMandatoryNodes().contains(s));
        this.numOrder = 1;
        ++this.numOrder;
        ISetIterator iSetIterator = this.g.getPotentialNeighborsOf(s).iterator();
        while (iSetIterator.hasNext()) {
            int next = (Integer)iSetIterator.next();
            if (this.num[next] != 0) continue;
            int[] LowMand = this.doFindArticulation(next, s);
            int lowN = LowMand[0];
            int mandN = LowMand[1];
            if (this.num[next] != lowN || mandN != 1 || this.g.getMandatoryNeighborsOf(s).contains(next)) continue;
            this.bridges.add(new int[]{s, next});
        }
    }

    private int[] doFindArticulation(int s, int parent) {
        ++this.numOrder;
        int lowpt = this.num[s];
        int mand = this.g.getMandatoryNodes().contains(s) ? 1 : 0;
        ISetIterator iSetIterator = this.g.getPotentialNeighborsOf(s).iterator();
        while (iSetIterator.hasNext()) {
            int next = (Integer)iSetIterator.next();
            if (this.num[next] == 0) {
                int[] LowMand = this.doFindArticulation(next, s);
                int lowN = LowMand[0];
                int mandN = LowMand[1];
                lowpt = Math.min(lowN, lowpt);
                mand = Math.max(mand, mandN);
                if (lowN < this.num[s] || mandN != 1) continue;
                this.articulationPoints.add(s);
                if (this.num[next] != lowN || this.g.getMandatoryNeighborsOf(s).contains(next)) continue;
                this.bridges.add(new int[]{s, next});
                continue;
            }
            if (this.num[next] >= this.num[s] || next == parent) continue;
            lowpt = Math.min(this.num[next], lowpt);
            mand = Math.max(mand, this.g.getMandatoryNodes().contains(next) ? 1 : 0);
        }
        return new int[]{lowpt, mand};
    }

    public ISet getArticulationPoints() {
        return this.articulationPoints;
    }

    public List<int[]> getBridges() {
        return this.bridges;
    }
}

