/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;

public interface IncidentSet {
    public ISet getPotentialSet(GraphVar var1, int var2);

    public ISet getMandatorySet(GraphVar var1, int var2);

    public boolean enforce(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public boolean remove(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public static class PredecessorsSet
    implements IncidentSet {
        @Override
        public ISet getPotentialSet(GraphVar graph, int i) {
            return graph.getPotentialPredecessorOf(i);
        }

        @Override
        public ISet getMandatorySet(GraphVar graph, int i) {
            return graph.getMandatoryPredecessorsOf(i);
        }

        @Override
        public boolean enforce(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.enforceEdge(to, from, cause);
        }

        @Override
        public boolean remove(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.removeEdge(to, from, cause);
        }
    }

    public static class SuccessorsSet
    implements IncidentSet {
        @Override
        public ISet getPotentialSet(GraphVar graph, int i) {
            return graph.getPotentialSuccessorsOf(i);
        }

        @Override
        public ISet getMandatorySet(GraphVar graph, int i) {
            return graph.getMandatorySuccessorsOf(i);
        }

        @Override
        public boolean enforce(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.enforceEdge(from, to, cause);
        }

        @Override
        public boolean remove(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.removeEdge(from, to, cause);
        }
    }
}

