/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.ringsearch.CyclicVertexSearch;

class RegularCyclicVertexSearch
implements CyclicVertexSearch {
    private final int[][] g;
    private long cyclic;
    private final List<Long> cycles = new ArrayList<Long>(1);
    private final List<Boolean> fused = new ArrayList<Boolean>(1);
    private long visited;
    private long[] state;
    private int[] colors;
    private int numCycles = 0;

    RegularCyclicVertexSearch(int[][] graph) {
        this.g = graph;
        int n = graph.length;
        if (n == 0) {
            return;
        }
        this.state = new long[n];
        this.search(0, 0L, 0L);
        int v = 1;
        while (Long.bitCount(this.visited) != n) {
            if (!this.visited(v)) {
                this.search(v, 0L, 0L);
            }
            ++v;
        }
        this.state = null;
    }

    private void search(int v, long prev, long curr) {
        this.state[v] = curr;
        curr = RegularCyclicVertexSearch.setBit(curr, v);
        this.visited |= curr;
        for (int w : this.g[v]) {
            if (this.visited(w)) {
                if (!RegularCyclicVertexSearch.isBitSet(prev, w)) continue;
                ++this.numCycles;
                this.add(this.state[w] ^ curr);
                continue;
            }
            this.search(w, this.state[v], curr);
        }
    }

    @Override
    public int numCycles() {
        return this.numCycles;
    }

    private boolean visited(int v) {
        return RegularCyclicVertexSearch.isBitSet(this.visited, v);
    }

    private void add(long cycle) {
        long intersect = this.cyclic & cycle;
        if (intersect != 0L && Long.bitCount(intersect) > 1) {
            this.addFused(cycle);
        } else {
            this.addIsolated(cycle);
        }
        this.cyclic |= cycle;
    }

    private void addIsolated(long cycle) {
        this.cycles.add(cycle);
        this.fused.add(Boolean.FALSE);
    }

    private void addFused(long cycle) {
        int i = this.indexOfFused(0, cycle);
        if (i != -1) {
            this.cycles.set(i, cycle | this.cycles.get(i));
            this.fused.set(i, Boolean.TRUE);
            int j = i;
            while ((j = this.indexOfFused(j + 1, this.cycles.get(i))) != -1) {
                this.cycles.set(i, this.cycles.remove(j) | this.cycles.get(i));
                this.fused.remove(j);
                --j;
            }
        } else {
            this.addIsolated(cycle);
        }
    }

    private int indexOfFused(int start, long cycle) {
        for (int i = start; i < this.cycles.size(); ++i) {
            long intersect = this.cycles.get(i) & cycle;
            if (intersect == 0L || Long.bitCount(intersect) <= 1) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] vertexColor() {
        int[] result = this.colors;
        if (result == null) {
            RegularCyclicVertexSearch regularCyclicVertexSearch = this;
            synchronized (regularCyclicVertexSearch) {
                result = this.colors;
                if (result == null) {
                    this.colors = result = this.buildVertexColor();
                }
            }
        }
        return result;
    }

    private int[] buildVertexColor() {
        int[] color = new int[this.g.length];
        int n = 1;
        Arrays.fill(color, -1);
        for (long cycle : this.cycles) {
            for (int i = 0; i < this.g.length; ++i) {
                if ((cycle & 1L) == 1L) {
                    color[i] = color[i] < 0 ? n : 0;
                }
                cycle >>= 1;
            }
            ++n;
        }
        return color;
    }

    @Override
    public boolean cyclic(int v) {
        return RegularCyclicVertexSearch.isBitSet(this.cyclic, v);
    }

    @Override
    public boolean cyclic(int u, int v) {
        int[] colors = this.vertexColor();
        if (colors[u] < 0 || colors[v] < 0) {
            return false;
        }
        if (colors[u] == 0 || colors[v] == 0) {
            for (long cycle : this.cycles) {
                if (!RegularCyclicVertexSearch.isBitSet(cycle, u) || !RegularCyclicVertexSearch.isBitSet(cycle, v)) continue;
                return true;
            }
            return false;
        }
        return colors[u] == colors[v];
    }

    @Override
    public int[] cyclic() {
        return RegularCyclicVertexSearch.toArray(this.cyclic);
    }

    @Override
    public int[][] isolated() {
        ArrayList<int[]> isolated = new ArrayList<int[]>(this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            if (this.fused.get(i).booleanValue()) continue;
            isolated.add(RegularCyclicVertexSearch.toArray(this.cycles.get(i)));
        }
        return (int[][])isolated.toArray((T[])new int[isolated.size()][]);
    }

    @Override
    public int[][] fused() {
        ArrayList<int[]> fused = new ArrayList<int[]>(this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            if (!this.fused.get(i).booleanValue()) continue;
            fused.add(RegularCyclicVertexSearch.toArray(this.cycles.get(i)));
        }
        return (int[][])fused.toArray((T[])new int[fused.size()][]);
    }

    static int[] toArray(long set) {
        int[] vertices = new int[Long.bitCount(set)];
        int i = 0;
        int v = 0;
        while (i < vertices.length) {
            if (RegularCyclicVertexSearch.isBitSet(set, v)) {
                vertices[i++] = v;
            }
            ++v;
        }
        return vertices;
    }

    static boolean isBitSet(long value, int bit) {
        return (value & 1L << bit) != 0L;
    }

    static long setBit(long value, int bit) {
        return value | 1L << bit;
    }
}

