/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.stochastic.operator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.structgen.stochastic.PartialFilledStructureMerger;
import org.openscience.cdk.structgen.stochastic.operator.ChemGraph;
import org.openscience.cdk.tools.SaturationChecker;

public class CrossoverMachine {
    final PartialFilledStructureMerger pfsm = new PartialFilledStructureMerger();
    final int splitMode = 2;
    final int numatoms = 5;
    public static final int SPLIT_MODE_RADNDOM = 0;
    public static final int SPLIT_MODE_DEPTH_FIRST = 1;
    public static final int SPLIT_MODE_BREADTH_FIRST = 2;

    public List<IAtomContainer> doCrossover(IAtomContainer dad, IAtomContainer mom) throws CDKException {
        int tries = 0;
        do {
            Object item2;
            int dim = dad.getAtomCount();
            IAtomContainer[] redChild = new IAtomContainer[2];
            IAtomContainer[] blueChild = new IAtomContainer[2];
            List<Object> redAtoms = new ArrayList();
            ArrayList<Integer> blueAtoms = new ArrayList<Integer>();
            ChemGraph graph = new ChemGraph(dad);
            graph.setNumAtoms(5);
            redAtoms = graph.pickBFgraph();
            for (int i = 0; i < dim; ++i) {
                Integer n = i;
                if (redAtoms.contains(n)) continue;
                blueAtoms.add(n);
            }
            redChild[0] = (IAtomContainer)dad.getBuilder().newInstance(IAtomContainer.class, new Object[]{dad});
            blueChild[0] = (IAtomContainer)dad.getBuilder().newInstance(IAtomContainer.class, new Object[]{dad});
            redChild[1] = (IAtomContainer)dad.getBuilder().newInstance(IAtomContainer.class, new Object[]{mom});
            blueChild[1] = (IAtomContainer)dad.getBuilder().newInstance(IAtomContainer.class, new Object[]{mom});
            ArrayList<IAtom> blueAtomsInRedChild0 = new ArrayList<IAtom>();
            for (Integer n : blueAtoms) {
                blueAtomsInRedChild0.add(redChild[0].getAtom(n.intValue()));
            }
            for (IAtom iAtom : blueAtomsInRedChild0) {
                redChild[0].removeAtom(iAtom);
            }
            ArrayList<IAtom> blueAtomsInRedChild1 = new ArrayList<IAtom>();
            for (Integer blueAtom : blueAtoms) {
                blueAtomsInRedChild1.add(redChild[1].getAtom(blueAtom.intValue()));
            }
            for (Object item2 : blueAtomsInRedChild1) {
                redChild[1].removeAtom((IAtom)item2);
            }
            ArrayList<IAtom> arrayList = new ArrayList<IAtom>();
            for (Integer n : redAtoms) {
                arrayList.add(blueChild[0].getAtom(n.intValue()));
            }
            item2 = arrayList.iterator();
            while (item2.hasNext()) {
                IAtom iAtom = (IAtom)item2.next();
                blueChild[0].removeAtom(iAtom);
            }
            ArrayList<IAtom> redAtomsInBlueChild1 = new ArrayList<IAtom>();
            for (Integer n : redAtoms) {
                redAtomsInBlueChild1.add(blueChild[1].getAtom(n.intValue()));
            }
            for (IAtom iAtom : redAtomsInBlueChild1) {
                blueChild[1].removeAtom(iAtom);
            }
            SaturationChecker saturationChecker = new SaturationChecker();
            double d = 0.0;
            for (int i = 0; i < redChild[0].getAtomCount(); ++i) {
                d += saturationChecker.getCurrentMaxBondOrder(redChild[0].getAtom(i), redChild[0]);
            }
            double red2attachpoints = 0.0;
            for (int i = 0; i < redChild[1].getAtomCount(); ++i) {
                red2attachpoints += saturationChecker.getCurrentMaxBondOrder(redChild[1].getAtom(i), redChild[1]);
            }
            boolean isok = true;
            if (d % 2.0 == 1.0 ^ red2attachpoints % 2.0 == 1.0) {
                isok = false;
                IAtomContainer firstToBalance = redChild[1];
                IAtomContainer secondToBalance = blueChild[0];
                if (d % 2.0 == 1.0) {
                    firstToBalance = redChild[0];
                    secondToBalance = blueChild[1];
                }
                for (IAtom atom : firstToBalance.atoms()) {
                    if (saturationChecker.getCurrentMaxBondOrder(atom, firstToBalance) % 2.0 != 1.0 || firstToBalance.getBondOrderSum(atom) % 2.0 != 0.0) continue;
                    firstToBalance.removeAtom(atom);
                    secondToBalance.addAtom(atom);
                    isok = true;
                    break;
                }
            }
            if (!isok) continue;
            IAtomContainerSet[] newstrucs = new IAtomContainerSet[2];
            newstrucs[0] = (IAtomContainerSet)dad.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            newstrucs[0].add(ConnectivityChecker.partitionIntoMolecules((IAtomContainer)redChild[0]));
            newstrucs[0].add(ConnectivityChecker.partitionIntoMolecules((IAtomContainer)blueChild[1]));
            newstrucs[1] = (IAtomContainerSet)dad.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            newstrucs[1].add(ConnectivityChecker.partitionIntoMolecules((IAtomContainer)redChild[1]));
            newstrucs[1].add(ConnectivityChecker.partitionIntoMolecules((IAtomContainer)blueChild[0]));
            ArrayList<IAtomContainer> children = new ArrayList<IAtomContainer>(2);
            for (int f = 0; f < 2; ++f) {
                try {
                    children.add(f, this.pfsm.generate(newstrucs[f]));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (children.size() != 2 || !ConnectivityChecker.isConnected((IAtomContainer)((IAtomContainer)children.get(0))) || !ConnectivityChecker.isConnected((IAtomContainer)((IAtomContainer)children.get(1)))) continue;
            return children;
        } while (++tries <= 20);
        throw new CDKException("Could not mate these properly");
    }
}

