## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
# Load required packages
library(tourr)
library(lionfish)

# Initialize python backend
if (check_venv()){
init_env(env_name = "r-lionfish", virtual_env = "virtual_env")
} else if (check_conda_env()){
init_env(env_name = "r-lionfish", virtual_env = "anaconda")
}

## ----Load and prepare flea data-----------------------------------------------
data("flea")
data <- apply(flea[,1:6], 2, function(x) (x-mean(x))/sd(x))
clusters <- as.numeric(flea$species)
flea_subspecies <- unique(flea$species)

guided_tour_history <- save_history(data,
                                    tour_path=guided_tour(holes()))
grand_tour_history_1d <- save_history(data,
                                      tour_path=grand_tour(d=1))

half_range <- max(sqrt(rowSums(data^2)))
feature_names <- colnames(data)

obj1 <- list(type="2d_tour", obj=guided_tour_history)
obj2 <- list(type="1d_tour", obj=grand_tour_history_1d)
obj3 <- list(type="scatter", obj=c("tars1", "tars2"))
obj4 <- list(type="hist", obj="head")

if (check_venv()){
init_env(env_name = "r-lionfish", virtual_env = "virtual_env")
} else if (check_conda_env()){
init_env(env_name = "r-lionfish", virtual_env = "anaconda")
}
  
  
if (interactive()){
interactive_tour(data=data,
                 plot_objects=list(obj1, obj2, obj3, obj4),
                 feature_names=feature_names,
                 half_range=half_range,
                 n_plot_cols=2,
                 preselection=clusters,
                 preselection_names=flea_subspecies,
                 n_subsets=5,
                 display_size=4.5)
}

