/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;

public class SCatSequence
extends Notifier {
    int[] seqToCat = null;
    int[] catToSeq = null;
    SVar v;
    int cats;
    Object owner;
    boolean notifyVar = false;

    public SCatSequence(SVar sVar, Object object, boolean bl) {
        this.v = sVar;
        this.owner = object;
        this.cats = this.v != null ? this.v.getNumCats() : 0;
        this.notifyVar = bl;
    }

    public SCatSequence(SVar sVar) {
        this(sVar, null, false);
    }

    public void setNotifyVarOnChange(boolean bl) {
        this.notifyVar = bl;
    }

    public Object getOwner() {
        return this.owner;
    }

    void updateCats() {
        if (this.v == null) {
            return;
        }
        int n = this.v.getNumCats();
        if (n == this.cats) {
            return;
        }
        if (n == 0 || this.seqToCat == null || this.catToSeq == null) {
            this.catToSeq = null;
            this.seqToCat = null;
            this.cats = n;
            return;
        }
        this.catToSeq = null;
        this.seqToCat = null;
        this.cats = n;
    }

    public int size() {
        return this.cats;
    }

    public int catAtPos(int n) {
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": catAtPos(" + n + ") out of range (" + this.cats + " cats)");
        }
        return this.seqToCat == null ? n : this.seqToCat[n];
    }

    public int posOfCat(int n) {
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": posOfCat(" + n + ") out of range (" + this.cats + " cats)");
        }
        return this.catToSeq == null ? n : this.catToSeq[n];
    }

    void createFields() {
        this.catToSeq = null;
        this.seqToCat = null;
        if (this.cats < 1) {
            return;
        }
        this.seqToCat = new int[this.cats];
        this.catToSeq = new int[this.cats];
        for (int i = 0; i < this.cats; ++i) {
            this.seqToCat[i] = i;
            this.catToSeq[i] = i;
        }
    }

    public void reset() {
        if (this.seqToCat != null || this.catToSeq != null) {
            this.catToSeq = null;
            this.seqToCat = null;
            if (this.notifyVar) {
                this.v.NotifyAll(new NotifyMsg(this, 12291));
            } else {
                this.NotifyAll(new NotifyMsg(this, 24576));
            }
        }
    }

    public boolean swapCatsAtPositions(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0 || n >= this.cats || n2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": swapCatsAtPositions(" + n + "," + n2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int n4 = this.seqToCat[n];
        this.seqToCat[n] = n3 = this.seqToCat[n2];
        this.seqToCat[n2] = n4;
        this.catToSeq[n4] = n2;
        this.catToSeq[n3] = n;
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public boolean swapCats(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.cats || n2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": swapCats(" + n + "," + n2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int n3 = this.catToSeq[n];
        int n4 = this.catToSeq[n2];
        this.seqToCat[n3] = n2;
        this.seqToCat[n4] = n;
        this.catToSeq[n] = n4;
        this.catToSeq[n2] = n3;
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public boolean moveCatAtPosTo(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n < 0 || n2 < 0 || n >= this.cats || n2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": moveCatAtPosTo(" + n + "," + n2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int n3 = this.seqToCat[n];
        if (n < n2) {
            int n4 = n;
            while (n4 < n2) {
                int n5;
                this.seqToCat[n4] = n5 = this.seqToCat[n4 + 1];
                this.catToSeq[n5] = n4++;
            }
            this.seqToCat[n4] = n3;
            this.catToSeq[n3] = n4;
        } else {
            int n6 = n;
            while (n6 > n2) {
                int n7;
                this.seqToCat[n6] = n7 = this.seqToCat[n6 - 1];
                this.catToSeq[n7] = n6--;
            }
            this.seqToCat[n6] = n3;
            this.catToSeq[n3] = n6;
        }
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public String toString() {
        return "SCatSequence(var=\"" + (this.v == null ? "<null>" : this.v.name) + "\",cats=" + this.cats + (this.seqToCat == null ? ",straight" : ",mapped") + ")";
    }
}

