## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(funIHC)

rds_path <- system.file("extdata", "U1505.rds", package = "funIHC")
example_data <- readRDS(rds_path) #Data from Table 2 in the paper, with M=15 and sigma = 0.05 

Data <- example_data$Data
Data = t(Data)
x = 1:15 #Number of time points (M=15 or 200 in the simulations)

res = funIHC(x,Data,type=0) #Run funIHC, type refers to the choice of distance metric: curves (0), first derivative (1) or coefficients (2)

table(res$label)



