data {
  int<lower=0> NN;
  real yhat;
  real yhat2;
  real stdev;
  vector[NN] b;
  vector[NN] s;
  vector[NN] d;
  vector[NN] e;
  vector[NN] en;
  vector[2 * NN] ab_values; 
  vector[3 * NN] skn_values; 
  vector[2 * NN] de_values;
  vector[NN] ex_values; 
  vector[NN] exneg_values;
  real threshold_value;
}

transformed data {
  vector [NN] xi;
  vector[2 * NN] ab;
  vector[3 * NN] skn;
  vector[2 * NN] de;
  vector[NN] ex;
  vector[NN] exneg;
  
  ab = ab_values;
  skn = skn_values;
  de = de_values;
  ex = ex_values;
  exneg = exneg_values;

  for (i in 1:NN) {
    if (b[i] > 0 && b[i] != 999) {
      xi[i] = beta_rng(ab[2*i-1], ab[2*i]);
    } else if (s[i] > 0 && s[i] != 999) {
      xi[i] = skew_normal_rng(skn[3*i-2], skn[3*i-1], skn[3*i]);
    } else if (d[i] > 0 && d[i] != 999) {
      xi[i] = double_exponential_rng(de[2*i-1], de[2*i]);
    } else if (e[i] > 0 && e[i] != 999) {
      xi[i] = exponential_rng(ex[i]);
    } else if (en[i] > 0 && en[i] != 999) {
      xi[i] = -exponential_rng(exneg[i]);
    }
  }
}

parameters {
  real thetastar;
}

transformed parameters {
  real theta;
  real mid;
  theta = thetastar - sum(xi);
  if (threshold_value * theta > 0){
     mid = step(abs(theta) - abs(threshold_value));
  } else if (threshold_value < 0){
     mid = step(threshold_value);}
     else if (theta < 0){
     mid = step(theta);
     } else
     {
      mid = step(abs(theta - (threshold_value)));
     }
}

model {
  thetastar ~ normal(yhat2, pow(10,5));
  yhat ~ normal(thetastar, stdev);
}
