## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("r_times")
r_times <- r_times[r_times < 60] # This example is a Peak Procedure trial, so we keep only the responses up to the FI value of 60s.

head(r_times, n = 30)

cr <- seq_along(r_times) # The Cumulative Response from 1 to n data points.

cr

## -----------------------------------------------------------------------------
int_index <- curv_index_int(cr, r_times)
fry_index <- curv_index_fry(cr, r_times, 60)

## ----echo = FALSE-------------------------------------------------------------
paste("Numerical integration index: ", int_index)
paste("Fry's integration index: ", fry_index)

## ----echo = FALSE-------------------------------------------------------------
trunc_int <- trunc(int_index * 10^4) / 10^4
trunc_fry <- trunc(fry_index * 10^4) / 10^4

plot(r_times, cr,
  type = "l", col = "blue",
  panel.first = grid(),
  xlab = "Time (s)",
  ylab = "Cummulative Response"
)
segments(
  x0 = min(r_times), y0 = 0,
  x1 = max(r_times), y1 = max(cr)
)
segments(
  x0 = max(r_times), y0 = 0,
  x1 = max(r_times), y1 = max(cr)
)
segments(
  x0 = min(r_times), y0 = 0,
  x1 = max(r_times), y1 = 0
)
segments(
  x0 = min(r_times) + (max(r_times) - min(r_times)) / 2, y0 = min(cr),
  x1 = max(r_times), y1 = max(cr),
  col = "red"
)
legend(
  "topleft",
  legend = c(
    paste("int_index: ", trunc_int),
    paste("fry_index: ", trunc_fry)
  ),
)

