/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.tstoolkit.maths.linearfilters.LinearFilterException;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;

public final class FilterFactory {
    public static SymmetricFilter makeFilterForGlobalRSM(double rsm) {
        if (rsm < 2.5) {
            return FilterFactory.makeSymmetricFilter(3, 3);
        }
        if (rsm >= 2.5 && rsm < 3.5) {
            return null;
        }
        if (rsm >= 3.5 && rsm < 5.5) {
            return FilterFactory.makeSymmetricFilter(3, 5);
        }
        if (rsm >= 5.5 && rsm < 6.5) {
            return null;
        }
        return FilterFactory.makeSymmetricFilter(3, 9);
    }

    public static SymmetricFilter makeMCDFilter(double[] data) {
        int idx = -1;
        for (int i = data.length - 1; i >= 0; --i) {
            if (!(data[i] >= 1.0)) continue;
            idx = i + 2;
            break;
        }
        if (idx == -1) {
            return FilterFactory.makeSymmetricFilter(0);
        }
        if (idx > 6) {
            return FilterFactory.makeSymmetricFilter(2, 6);
        }
        if (idx % 2 == 0) {
            return FilterFactory.makeSymmetricFilter(2, idx);
        }
        return FilterFactory.makeSymmetricFilter(idx / 2);
    }

    public static SymmetricFilter makeSymmetricFilter(int length) {
        if (length % 2 == 0) {
            throw new LinearFilterException("Invalid length for Henderson filter. Should be odd");
        }
        double[] c = new double[length / 2 + 1];
        double w = 1.0 / (double)length;
        for (int i = 0; i < c.length; ++i) {
            c[i] = w;
        }
        return SymmetricFilter.of(c);
    }

    public static SymmetricFilter makeSymmetricFilter(int m, int n) {
        Polynomial M = FilterFactory.simpleFilter(m);
        Polynomial N = FilterFactory.simpleFilter(n);
        return SymmetricFilter.createFromWeights(M.times(N));
    }

    static Polynomial simpleFilter(int len) {
        double[] c = new double[len];
        double w = 1.0 / (double)len;
        for (int i = 0; i < len; ++i) {
            c[i] = w;
        }
        return Polynomial.of(c);
    }

    private FilterFactory() {
    }
}

