/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.DiffuseState;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.IDiffuseFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.VarianceFilter;
import ec.tstoolkit.utilities.Arrays2;

public class DiffuseVarianceFilter
extends VarianceFilter
implements IDiffuseFilteringResults {
    MatrixStorage m_Pi;
    DataBlockStorage m_Ci;
    double[] m_fi;
    int m_enddiffusepos;
    int m_ndiffuse;

    public DiffuseVarianceFilter() {
    }

    public DiffuseVarianceFilter(boolean hasC) {
        super(hasC);
    }

    private void checkdiffusepos(int pos) {
        if (pos < this.m_enddiffusepos) {
            return;
        }
        this.m_enddiffusepos = pos + 1;
        super.checkSize(this.m_enddiffusepos);
        if (this.m_fi == null || this.m_enddiffusepos > this.m_fi.length) {
            double[] tmp = new double[DataBlockStorage.calcSize(this.m_enddiffusepos)];
            if (this.m_fi != null) {
                Arrays2.copy(this.m_fi, tmp, this.m_fi.length);
            }
            this.m_fi = tmp;
            if (this.m_bC) {
                this.m_Ci.resize(this.m_enddiffusepos);
            }
            if (this.m_bP) {
                this.m_Pi.resize(this.m_enddiffusepos);
            }
        }
    }

    public DataBlock Ci(int t) {
        return this.m_Ci == null ? null : this.m_Ci.block(t);
    }

    @Override
    public void clear() {
        this.m_Pi = null;
        this.m_Ci = null;
        this.m_fi = null;
        this.m_enddiffusepos = 0;
        this.m_ndiffuse = 0;
        super.clear();
    }

    @Override
    public void closeDiffuse() {
    }

    public double Fi(int t) {
        return this.m_fi == null || t >= this.m_fi.length ? 0.0 : this.m_fi[t];
    }

    public double getDiffuseCount() {
        return this.m_ndiffuse;
    }

    public int getEndDiffusePosition() {
        return this.m_enddiffusepos;
    }

    public SubMatrix Pi(int t) {
        if (this.m_Pi == null) {
            return null;
        }
        return this.m_Pi.matrix(t);
    }

    @Override
    public void prepareDiffuse(ISsf ssf, ISsfData data) {
        this.clear();
        this.m_ssf = ssf;
        this.m_dim = ssf.getStateDim();
        int ndiffuse = this.m_ssf.getNonStationaryDim();
        super.init(ssf, ndiffuse);
        if (this.m_bC) {
            this.m_Ci = new DataBlockStorage(this.m_dim, ndiffuse);
        }
        if (this.m_bP) {
            this.m_Pi = new MatrixStorage(this.m_dim, ndiffuse);
        }
        this.m_fi = new double[ndiffuse];
    }

    @Override
    public void process(FilteredData fdata, int startpos, double[] data, double[] initialstate) {
        double e;
        DataBlock a = new DataBlock(this.m_dim);
        if (initialstate != null) {
            a.copyFrom(initialstate, 0);
        }
        int imax = this.m_n - 1;
        for (int i = startpos; i < imax; ++i) {
            double c;
            fdata.m_e[i] = e = data[i] - this.m_ssf.ZX(i, a);
            if (fdata.m_bA) {
                fdata.A(i).copy(a);
            }
            this.m_ssf.TX(i, a);
            if (this.m_nd[i]) continue;
            if (i >= this.m_enddiffusepos || this.m_fi[i] == 0.0) {
                c = e / this.m_f[i];
                a.addAY(c, this.C(i));
                continue;
            }
            c = e / this.m_fi[i];
            a.addAY(c, this.Ci(i));
        }
        fdata.m_e[imax] = e = data[imax] - this.m_ssf.ZX(imax, a);
        if (fdata.m_bA) {
            fdata.A(imax).copy(a);
        }
    }

    @Override
    public void save(int t, DiffuseState state) {
        double fi;
        this.checkdiffusepos(t);
        super.save(t, state);
        this.m_fi[t] = fi = state.fi;
        if (this.m_bC) {
            this.m_Ci.save(t, state.Ci);
        }
        if (this.m_bP) {
            this.m_Pi.save(t, state.Pi);
        }
        if (fi != 0.0 && !state.isMissing()) {
            ++this.m_ndiffuse;
        }
    }
}

