/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.satoolkit.SaException;

public class ResidualSeasonalityDiagnostics {
    public static final Configuration defaultConfiguration = new Configuration();

    public static class Configuration
    implements Cloneable {
        public static final double SASEV = 0.01;
        public static final double SABAD = 0.05;
        public static final double SAUNC = 0.1;
        public static final double ISEV = 0.01;
        public static final double IBAD = 0.05;
        public static final double IUNC = 0.1;
        public static final double SA3SEV = 0.01;
        public static final double SA3BAD = 0.05;
        public static final double SA3UNC = 0.1;
        private double m_SASevere = 0.01;
        private double m_SABad = 0.05;
        private double m_SAUncertain = 0.1;
        private double m_IrrSevere = 0.01;
        private double m_IrrBad = 0.05;
        private double m_IrrUncertain = 0.1;
        private double m_SA3Severe = 0.01;
        private double m_SA3Bad = 0.05;
        private double m_SA3Uncertain = 0.1;
        private boolean m_Enabled = true;

        private static void check(double severe, double bad, double unc) {
            if (severe > bad || bad > unc || unc > 1.0 || severe <= 0.0) {
                throw new SaException("SA", "Invalid settings");
            }
        }

        public Configuration clone() {
            try {
                return (Configuration)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError();
            }
        }

        public double getIrrBad() {
            return this.m_IrrBad;
        }

        public double getIrrSevere() {
            return this.m_IrrSevere;
        }

        public double getIrrUncertain() {
            return this.m_IrrUncertain;
        }

        public double getSA3Bad() {
            return this.m_SA3Bad;
        }

        public double getSA3Severe() {
            return this.m_SA3Severe;
        }

        public double getSA3Uncertain() {
            return this.m_SA3Uncertain;
        }

        public double getSABad() {
            return this.m_SABad;
        }

        public double getSASevere() {
            return this.m_SASevere;
        }

        public double getSAUncertain() {
            return this.m_SAUncertain;
        }

        public boolean idEnabled() {
            return this.m_Enabled;
        }

        public void seEnabled(boolean value) {
            this.m_Enabled = value;
        }

        public void setIrrthresholds(double severe, double bad, double uncertain) {
            Configuration.check(severe, bad, uncertain);
            this.m_IrrSevere = severe;
            this.m_IrrBad = bad;
            this.m_IrrUncertain = uncertain;
        }

        public void setSA3thresholds(double severe, double bad, double uncertain) {
            Configuration.check(severe, bad, uncertain);
            this.m_SA3Severe = severe;
            this.m_SA3Bad = bad;
            this.m_SA3Uncertain = uncertain;
        }

        public void setSAthresholds(double severe, double bad, double uncertain) {
            Configuration.check(severe, bad, uncertain);
            this.m_SASevere = severe;
            this.m_SABad = bad;
            this.m_SAUncertain = uncertain;
        }
    }
}

