/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

public class RadicalInverse {
    private static final int NP = 168;
    private static final int PLIM = 1000;
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997};
    private static final int NRILIM = 1000;
    private int b;
    private double invb;
    private double logb;
    private int JMAX;
    private int co = 0;
    private double xx;
    private long ix;

    public RadicalInverse(int n, double d) {
        this.b = n;
        this.invb = 1.0 / (double)n;
        this.logb = Math.log(n);
        this.JMAX = (int)(22.18070977791825 / this.logb);
        this.xx = d;
        this.ix = this.computeI(d);
    }

    private long computeI(double d) {
        int n;
        int[] nArray = new int[this.JMAX];
        for (n = 0; n < this.JMAX && d > 5.0E-16; d -= (double)nArray[n], ++n) {
            nArray[n] = (int)(d *= (double)this.b);
        }
        long l = 0L;
        for (n = this.JMAX - 1; n >= 0; --n) {
            l = l * (long)this.b + (long)nArray[n];
        }
        return l;
    }

    public static int[] getPrimes(int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = Math.min(168, n);
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = PRIMES[n2];
        }
        if (168 < n) {
            n2 = 168;
            int n4 = 1001;
            while (n2 < n) {
                boolean bl;
                nArray[n2] = n4;
                int n5 = 1;
                while ((bl = nArray[n5] <= n4 / nArray[n5]) && n4 % nArray[n5] > 0) {
                    ++n5;
                }
                if (!bl) {
                    ++n2;
                }
                n4 += 2;
            }
        }
        return nArray;
    }

    public static double radicalInverse(int n, long l) {
        double d;
        double d2 = d = 1.0 / (double)n;
        double d3 = 0.0;
        while (l > 0L) {
            d3 += d2 * (double)(l % (long)n);
            d2 *= d;
            l /= (long)n;
        }
        return d3;
    }

    public static double nextRadicalInverse(double d, double d2) {
        double d3 = d2 + d;
        if (d3 < 0.9999999999) {
            return d3;
        }
        double d4 = d;
        double d5 = d * d;
        while (d2 + d5 >= 0.9999999999) {
            d4 = d5;
            d5 *= d;
        }
        return d2 + (d4 - 1.0) + d5;
    }

    public double nextRadicalInverse() {
        ++this.co;
        if (this.co >= 1000) {
            this.co = 0;
            this.ix += 1000L;
            this.xx = RadicalInverse.radicalInverse(this.b, this.ix);
            return this.xx;
        }
        double d = this.xx + this.invb;
        if (d < 0.9999999999) {
            this.xx = d;
            return this.xx;
        }
        double d2 = this.invb;
        double d3 = this.invb * this.invb;
        while (this.xx + d3 >= 0.9999999999) {
            d2 = d3;
            d3 *= this.invb;
        }
        this.xx += d2 - 1.0 + d3;
        return this.xx;
    }

    public static void reverseDigits(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i];
        }
    }

    public static int integerRadicalInverse(int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            n3 = n3 * n + n2 % n;
            n2 /= n;
        }
        return n3;
    }

    public static int nextRadicalInverseDigits(int n, int n2, int[] nArray) {
        int n3;
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            if (nArray[n3] != n - 1) {
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
                return n2;
            }
            nArray[n3] = 0;
        }
        if (n3 == 0) {
            nArray[n2] = 1;
            return ++n2;
        }
        return 0;
    }

    public static void getFaurePermutation(int n, int[] nArray) {
        if (n == 2) {
            nArray[0] = 0;
            nArray[1] = 1;
        } else if ((n & 1) != 0) {
            int n2;
            RadicalInverse.getFaurePermutation(--n, nArray);
            for (n2 = 0; n2 < n; ++n2) {
                if (nArray[n2] < n / 2) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
            }
            for (n2 = n; n2 > n / 2; --n2) {
                nArray[n2] = nArray[n2 - 1];
            }
            nArray[n / 2] = n / 2;
        } else {
            RadicalInverse.getFaurePermutation(n /= 2, nArray);
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                nArray[n4] = nArray[n4] * 2;
                nArray[i + n] = nArray[i] + 1;
            }
        }
    }

    public static double permutedRadicalInverse(int n, int[] nArray, int n2) {
        double d;
        double d2 = d = 1.0 / (double)n;
        double d3 = 0.0;
        while (n2 > 0) {
            d3 += d2 * (double)nArray[n2 % n];
            d2 *= d;
            n2 /= n;
        }
        return d3;
    }
}

