/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.MicrosatelliteModel;
import dr.oldevomodel.substmodel.OnePhaseModel;
import java.util.ArrayList;

public class TwoPhaseModel
extends MicrosatelliteModel {
    private Parameter geoParam;
    private Parameter onePhasePrParam;
    private Parameter transformParam;
    private boolean estimateSubmodelParams = false;
    private ArrayList<Variable<Double>> submodelParameters = null;
    private boolean updateSubmodelRates = false;
    public static final String TWO_PHASE_MODEL = "TWOPHASEModel";
    private Parameter transOnePhase;
    private Parameter transGeo;

    public TwoPhaseModel(Microsatellite microsatellite, FrequencyModel frequencyModel, OnePhaseModel onePhaseModel, Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl) {
        super(TWO_PHASE_MODEL, microsatellite, frequencyModel, null);
        this.subModel = onePhaseModel;
        this.estimateSubmodelParams = bl;
        if (this.estimateSubmodelParams) {
            this.submodelParameters = new ArrayList();
            for (int i = 0; i < this.subModel.getNestedParameterCount(); ++i) {
                this.addVariable(this.subModel.getNestedParameter(i));
                this.submodelParameters.add(this.subModel.getNestedParameter(i));
            }
            this.updateSubmodelRates = true;
        }
        this.geoParam = parameter2;
        this.onePhasePrParam = parameter;
        this.addVariable(this.geoParam);
        this.addVariable(this.onePhasePrParam);
        this.estimateSubmodelParams = bl;
        this.transformParam = parameter3 != null ? parameter3 : new Parameter.Default(0.0);
        this.setupInfinitesimalRates();
        if (frequencyModel == null) {
            this.useStationaryFreqs = true;
            this.computeStationaryDistribution();
        } else {
            this.useStationaryFreqs = false;
        }
    }

    private void transform() {
        double d = this.transformParam.getParameterValue(0);
        double d2 = this.geoParam.getParameterValue(0);
        double d3 = this.onePhasePrParam.getParameterValue(0);
        if (d3 < 1.0 - d && d2 < 1.0 - d || d3 == d2 || d == 0.0) {
            this.transOnePhase = this.onePhasePrParam;
            this.transGeo = this.geoParam;
        } else if (d2 > Math.max(1.0 - d, d3)) {
            d3 = d3 * (d2 - (d2 + d - 1.0) / d) / d2 + (d2 + d - 1.0) / d;
            this.transOnePhase = new Parameter.Default(d3);
        } else if (d3 > Math.max(1.0 - d, d2)) {
            d2 = d2 * (d3 - (d3 + d - 1.0) / d) / d3 + (d3 + d - 1.0) / d;
            this.transGeo = new Parameter.Default(d2);
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (this.submodelParameters != null && this.submodelParameters.indexOf(variable) != -1) {
            this.updateSubmodelRates = true;
        }
        this.updateMatrix = true;
    }

    @Override
    public void setupInfinitesimalRates() {
        if (this.updateSubmodelRates) {
            this.subModel.setupInfinitesimalRates();
            this.updateSubmodelRates = false;
        }
        this.transform();
        double d = this.transGeo.getParameterValue(0);
        double d2 = this.transOnePhase.getParameterValue(0);
        TwoPhaseModel.setupInfinitesimalRates(this.stateCount, d, d2, this.infinitesimalRateMatrix, this.subModel.getInfinitesimalRates());
    }

    public static void setupInfinitesimalRates(int n, double d, double d2, double[][] dArray, double[][] dArray2) {
        double[] dArray3 = new double[n];
        for (int i = 1; i < n; ++i) {
            dArray3[i] = (1.0 - d) * Math.pow(d, i - 1);
        }
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = 1.0 - Math.pow(d, n - 1 - i);
            double d5 = 1.0 - Math.pow(d, i);
            double d6 = 0.0;
            double d7 = 0.0;
            for (int j = 0; j < n; ++j) {
                if (j < i) {
                    d3 = dArray3[Math.abs(i - j)] / d5;
                    d7 = dArray2[i][i - 1];
                } else if (j > i) {
                    d7 = dArray2[i][i + 1];
                    d3 = dArray3[Math.abs(i - j)] / d4;
                }
                if (i == j) continue;
                dArray[i][j] = i == j + 1 || i == j - 1 ? d7 * (d2 + (1.0 - d2) * d3) : d7 * (1.0 - d2) * d3;
                d6 += dArray[i][j];
            }
            dArray[i][i] = 0.0 - d6;
        }
    }

    @Override
    public void computeStationaryDistribution() {
        if (this.useStationaryFreqs) {
            this.computeTwoPhaseStationaryDistribution();
        }
        super.computeStationaryDistribution();
    }

    public MicrosatelliteModel getSubModel() {
        return this.subModel;
    }

    public Parameter getGeometricParamter() {
        return this.geoParam;
    }

    public Parameter getOnePhasePrParamter() {
        return this.onePhasePrParam;
    }

    public Parameter getTransGeometricParamter() {
        return this.transGeo;
    }

    public Parameter getTransOnePhasePrParamter() {
        return this.transOnePhase;
    }

    public Parameter getTransformParam() {
        return this.transformParam;
    }

    public boolean isEstimatingSubmodelParams() {
        return this.estimateSubmodelParams;
    }

    public void printDetails() {
        System.out.println("Details of the TwoPhase Model and its paramters:");
        System.out.println("a submodel:                     " + this.isNested);
        System.out.println("has submodel:                   " + this.hasSubmodel());
        if (this.hasSubmodel()) {
            System.out.println("submodel class:                 " + this.subModel.getClass());
        }
        System.out.println("esitmating submodel parameters: " + this.estimateSubmodelParams);
        System.out.println("one phase probability:          " + this.onePhasePrParam.getParameterValue(0));
        System.out.println("geometric parameter:            " + this.geoParam.getParameterValue(0));
        System.out.println("transformation parameter:       " + this.transformParam.getParameterValue(0));
    }
}

