/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous.hmc;

import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.inference.hmc.PrecisionMatrixVectorProductProvider;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.WrappedVector;
import dr.xml.Reportable;

public abstract class TreePrecisionTraitProductProvider
extends AbstractModel
implements PrecisionMatrixVectorProductProvider,
Reportable {
    final Tree tree;
    final Parameter dataParameter;
    protected final int dimTrait;
    protected final ContinuousDataLikelihoodDelegate likelihoodDelegate;

    TreePrecisionTraitProductProvider(TreeDataLikelihood treeDataLikelihood, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super("treePrecisionTraitProductProvider");
        this.tree = treeDataLikelihood.getTree();
        this.dataParameter = continuousDataLikelihoodDelegate.getDataModel().getParameter();
        this.likelihoodDelegate = continuousDataLikelihoodDelegate;
        this.dimTrait = continuousDataLikelihoodDelegate.getTraitDim();
        if (this.tree instanceof TreeModel) {
            this.addModel((TreeModel)this.tree);
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public ContinuousDataLikelihoodDelegate getLikelihoodDelegate() {
        return this.likelihoodDelegate;
    }

    public ContinuousTraitPartialsProvider getDataModel() {
        return this.likelihoodDelegate.getDataModel();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    double[] expensiveProduct(Parameter parameter, double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                d += dArray[i][j] * parameter.getParameterValue(j);
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    void debug(double[] dArray, Parameter parameter) {
        double[] dArray2 = this.expensiveProduct(parameter, this.likelihoodDelegate.getTreeTraitPrecision());
        System.err.println("via FCD: " + new WrappedVector.Raw(dArray));
        System.err.println("direct : " + new WrappedVector.Raw(dArray2));
        System.err.println();
    }

    @Override
    public String getReport() {
        double[] dArray = this.getProduct(this.dataParameter);
        return new WrappedVector.Raw(dArray, 0, dArray.length).toString();
    }
}

