/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jpmml.rexp.RDataInput;

public abstract class TextInput
implements RDataInput {
    private BufferedReader reader = null;

    public TextInput(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int first = reader.read();
        if (first != 65) {
            throw new IllegalArgumentException();
        }
        int second = reader.read();
        if (second != 10) {
            throw new IllegalArgumentException();
        }
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int readInt() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        if ("NA".equals(line)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(line);
    }

    @Override
    public double readDouble() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        return Double.parseDouble(line);
    }

    @Override
    public byte[] readByteArray(int length) throws IOException {
        byte[] bytes;
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException();
        }
        if (line.indexOf(92) > -1) {
            line = TextInput.decode(line);
        }
        if ((bytes = line.getBytes()).length != length) {
            throw new IOException();
        }
        return bytes;
    }

    public static String decode(String string) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char currChar = string.charAt(i);
            if (currChar == '\\') {
                char nextChar = string.charAt(i + 1);
                if (nextChar >= '0' && nextChar <= '8') {
                    int j;
                    int octalValue = nextChar - 48;
                    for (j = 0; j < 2 && i + 2 + j < string.length() && (nextChar = string.charAt(i + 2 + j)) >= '0' && nextChar <= '8'; ++j) {
                        octalValue = (octalValue << 3) + (nextChar - 48);
                    }
                    sb.append((char)octalValue);
                    i += 2 + j;
                    continue;
                }
                if (nextChar == '\\') {
                    sb.append('\\');
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            sb.append(currChar);
            ++i;
        }
        return sb.toString();
    }
}

