## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.align = "center")

## ---- eval = FALSE------------------------------------------------------------
#  library(postpack)
#  data(cjs)

## ---- echo = FALSE------------------------------------------------------------
library(postpack)
load("../data/cjs.rda")

## -----------------------------------------------------------------------------
post_dim(cjs)

## -----------------------------------------------------------------------------
get_params(cjs)

## -----------------------------------------------------------------------------
get_params(cjs, type = "base_index")

## -----------------------------------------------------------------------------
post_summ(cjs, params = c("sig_B0", "sig_B1"))

## -----------------------------------------------------------------------------
post_summ(cjs, c("sig_B0", "sig_B1"), digits = 3, probs = c(0.025, 0.25, 0.5, 0.75, 0.975))

## -----------------------------------------------------------------------------
post_summ(cjs, "b0")

## -----------------------------------------------------------------------------
post_summ(cjs, "^B", mcse = TRUE)

## -----------------------------------------------------------------------------
post_summ(cjs, "^B", by_chain = TRUE)

## -----------------------------------------------------------------------------
post_summ(cjs, c("sig_B0", "sig_B1"), neff = TRUE, Rhat = TRUE)

## ---- fig.width = 4, fig.height = 6-------------------------------------------
diag_plots(cjs, params = "SIG")

## -----------------------------------------------------------------------------
b0_samps = post_subset(cjs, "b0")

## -----------------------------------------------------------------------------
b0_samps = post_subset(cjs, "b0", matrix = TRUE)

## -----------------------------------------------------------------------------
head(post_subset(cjs, "b0", matrix = TRUE, chains = TRUE, iters = TRUE))

## ---- message = FALSE---------------------------------------------------------
# check out param names
get_params(cjs)

# remove all SIG nodes
cjs2 = post_remove(cjs, "SIG", ask = FALSE)

# did it work?
get_params(cjs2)

## -----------------------------------------------------------------------------
(SIG_ests = post_summ(cjs, "SIG", digits = 2))

## -----------------------------------------------------------------------------
array_format(SIG_ests["mean",])

## ---- message = FALSE---------------------------------------------------------
cjs2 = post_remove(cjs, "SIG[2,1]", ask = FALSE)
array_format(post_summ(cjs2, "SIG")["mean",])

## ---- messag = FALSE----------------------------------------------------------
SIG_decomp = vcov_decomp(cjs, param = "SIG")

## -----------------------------------------------------------------------------
class(SIG_decomp)

## -----------------------------------------------------------------------------
post_dim(cjs) == post_dim(SIG_decomp)

## -----------------------------------------------------------------------------
get_params(SIG_decomp, type = "base_index")

## -----------------------------------------------------------------------------
array_format(post_summ(SIG_decomp, "rho")["50%",])

## ---- eval = FALSE------------------------------------------------------------
#  post_thin(cjs, keep_percent = 0.25)

## -----------------------------------------------------------------------------
cjs = post_bind(post1 = cjs, post2 = SIG_decomp)

## -----------------------------------------------------------------------------
get_params(cjs)

## -----------------------------------------------------------------------------
post_summ(cjs, "sig")

## -----------------------------------------------------------------------------
# extract the raw samples from cjs in matrix form
b0_samps = post_subset(cjs, "b0", matrix = TRUE)

# perform a derived quantity calculation
eb0_samps = exp(b0_samps)/(1 + exp(b0_samps))

## -----------------------------------------------------------------------------
colnames(eb0_samps) = paste0("eb0[", 1:5, "]")

## -----------------------------------------------------------------------------
cjs = post_bind(post1 = cjs, post2 = eb0_samps)

