## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "",
    prompt = TRUE
)

## -----------------------------------------------------------------------------
library("wbacon")

## -----------------------------------------------------------------------------
data(bushfire, package = "modi")

## -----------------------------------------------------------------------------
head(bushfire)

## -----------------------------------------------------------------------------
data(bushfire.weights, package = "modi")

## -----------------------------------------------------------------------------
fit <- wBACON(bushfire, w = bushfire.weights, alpha = 0.05)
fit

## -----------------------------------------------------------------------------
summary(fit)

## -----------------------------------------------------------------------------
plot(fit, 1)

## -----------------------------------------------------------------------------
which(is_outlier(fit))

## -----------------------------------------------------------------------------
center(fit)

## -----------------------------------------------------------------------------
data(philips)
head(philips)

## -----------------------------------------------------------------------------
fit <- wBACON(philips, alpha = 0.05, version = "V1")
fit

## -----------------------------------------------------------------------------
plot(fit, which = 2)

## -----------------------------------------------------------------------------
plot(fit, which = 2, hex = TRUE)

## -----------------------------------------------------------------------------
data(education, package = "robustbase")

## -----------------------------------------------------------------------------
names(education)[3:6] <- c("RES", "INC", "YOUNG", "EXP")
head(education)

## -----------------------------------------------------------------------------
reg <- wBACON_reg(EXP ~ RES + INC + YOUNG, data = education)
reg

## -----------------------------------------------------------------------------
summary(reg)

## -----------------------------------------------------------------------------
summary(lm(EXP ~ RES + INC + YOUNG, data = education[!is_outlier(reg), ]))

## -----------------------------------------------------------------------------
plot(reg, 4)

