/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNeighBoolChannel
extends Propagator<Variable> {
    private final BoolVar[] bools;
    private final GraphVar g;
    private final int vertex;
    private final IncidentSet inc;

    public PropNeighBoolChannel(BoolVar[] neigh, int vertex, GraphVar gV, IncidentSet incSet) {
        super(ArrayUtils.append(neigh, {gV}), (Priority)PropagatorPriority.LINEAR, true);
        this.vertex = vertex;
        this.bools = neigh;
        this.g = gV;
        this.inc = incSet;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.bools.length) {
            return GraphEventType.ADD_EDGE.getMask() + GraphEventType.REMOVE_EDGE.getMask();
        }
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iSetIterator = this.inc.getPotentialSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.bools[i].getUB() == 0) {
                this.inc.remove(this.g, this.vertex, i, this);
                continue;
            }
            if (this.bools[i].getLB() != 1) continue;
            this.inc.enforce(this.g, this.vertex, i, this);
        }
        for (int i = 0; i < this.bools.length; ++i) {
            if (!this.inc.getPotentialSet(this.g, this.vertex).contains(i)) {
                this.bools[i].setToFalse(this);
                continue;
            }
            if (!this.inc.getMandatorySet(this.g, this.vertex).contains(i)) continue;
            this.bools[i].setToTrue(this);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.bools.length) {
            if (this.bools[idxVarInProp].getLB() == 1) {
                this.inc.enforce(this.g, this.vertex, idxVarInProp, this);
            } else {
                this.inc.remove(this.g, this.vertex, idxVarInProp, this);
            }
        } else {
            for (int i = 0; i < this.bools.length; ++i) {
                if (!this.inc.getPotentialSet(this.g, this.vertex).contains(i)) {
                    this.bools[i].setToFalse(this);
                    continue;
                }
                if (!this.inc.getMandatorySet(this.g, this.vertex).contains(i)) continue;
                this.bools[i].setToTrue(this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.bools.length; ++i) {
            if (this.bools[i].getLB() != 1 || this.inc.getPotentialSet(this.g, this.vertex).contains(i)) continue;
            return ESat.FALSE;
        }
        ISetIterator iSetIterator = this.inc.getMandatorySet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.bools[i].getUB() != 0) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

