if (!requireNamespace("hexSticker", quietly = TRUE)) {
  install.packages("hexSticker", repos = "https://cloud.r-project.org")
}
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  install.packages("ggplot2", repos = "https://cloud.r-project.org")
}

library(hexSticker)
library(ggplot2)

# Create the subplot with formulas
# White text to contrast with dark blue
p <- ggplot() +
  annotate("text", x = 0.5, y = 0.75, label = "X %->% Y", parse = TRUE, size = 12, color = "#ffffff") +
  annotate("text", x = 0.5, y = 0.25, label = "Y %->% X", parse = TRUE, size = 12, color = "#ffffff") +
  xlim(0, 1) + ylim(0, 1) +
  theme_void() +
  theme_transparent()

# Create the sticker
s <- sticker(
  subplot = p,
  package = "grangeRsearch",
  p_size = 20,             # Font size for package name
  s_x = 1,                 # Horizontal position of subplot
  s_y = 1.0,               # Vertical position of subplot
  s_width = 0.6,           # Width of subplot relative to hex
  h_fill = "#002366",      # Velvet blue background
  h_color = "#ffffff",     # White border
  p_color = "#ffffff",     # White text
  filename = "man/figures/logo.png"
)

print(s)