/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.EnvironmentField;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.ClassValuePicker;
import weka.knowledgeflow.steps.Step;

public class ClassValuePickerStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = 7009335918650499183L;
    protected JComboBox m_classValueCombo = new EnvironmentField.WideComboBox();

    @Override
    public void setStepToEdit(Step step) {
        this.copyOriginal(step);
        Instances incomingStructure = null;
        try {
            incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("dataSet");
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("trainingSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("testSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("instance");
            }
        }
        catch (WekaException ex) {
            this.showErrorDialog(ex);
        }
        if (incomingStructure != null) {
            if (incomingStructure.classIndex() < 0) {
                this.showInfoDialog("No class attribute is set in the data", "ClassValuePicker", true);
                this.add((Component)new JLabel("No class attribute set in data"), "Center");
            } else if (incomingStructure.classAttribute().isNumeric()) {
                this.showInfoDialog("Cant set class value - class is numeric!", "ClassValuePicker", true);
                this.add((Component)new JLabel("Can't set class value - class is numeric"), "Center");
            } else {
                this.m_classValueCombo.setEditable(true);
                this.m_classValueCombo.setToolTipText("Class label. /first, /last and /<num> can be used to specify the first, last or specific index of the label to use respectively");
                for (int i = 0; i < incomingStructure.classAttribute().numValues(); ++i) {
                    this.m_classValueCombo.addItem(incomingStructure.classAttribute().value(i));
                }
                String stepL = ((ClassValuePicker)this.getStepToEdit()).getClassValue();
                if (stepL != null && stepL.length() > 0) {
                    this.m_classValueCombo.setSelectedItem(stepL);
                }
                JPanel p = new JPanel(new BorderLayout());
                p.setBorder(BorderFactory.createTitledBorder("Choose class value"));
                p.add((Component)this.m_classValueCombo, "North");
                this.createAboutPanel(step);
                this.add((Component)p, "Center");
            }
        } else {
            super.setStepToEdit(step);
        }
    }

    @Override
    public void okPressed() {
        Object selected = this.m_classValueCombo.getSelectedItem();
        if (selected != null) {
            ((ClassValuePicker)this.getStepToEdit()).setClassValue(selected.toString());
        }
    }
}

