/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NumericalDerivatives
implements IFunctionDerivatives {
    private static final int nThreads = Runtime.getRuntime().availableProcessors();
    private double[] m_eps;
    private double[] m_fp;
    private double[] m_fm;
    private double[] m_grad;
    private Matrix m_h;
    private IFunction m_fn;
    private IReadDataBlock m_pt;
    private double m_fcur;
    private static int g_nsteps = 2;

    public NumericalDerivatives(IFunction fn, IFunctionInstance point, boolean sym) {
        this(fn, point, sym, false);
    }

    public NumericalDerivatives(IFunction fn, IFunctionInstance point, boolean sym, boolean mt) {
        this.m_fn = fn;
        this.m_fcur = point.getValue();
        this.m_pt = point.getParameters();
        int n = this.m_pt.getLength();
        this.m_fp = new double[n];
        this.m_eps = new double[n];
        if (!mt || n < 2) {
            if (!sym) {
                for (int i = 0; i < n; ++i) {
                    this.m_eps[i] = this.m_fn.getDomain().epsilon(this.m_pt, i);
                    this.checkepsilon(i);
                    this.m_fp[i] = this.newval(i, this.m_eps[i]);
                }
            } else {
                this.m_fm = new double[n];
                for (int i = 0; i < n; ++i) {
                    this.m_eps[i] = this.m_fn.getDomain().epsilon(this.m_pt, i);
                    this.checkepsilon(i);
                    this.m_fp[i] = this.newval(i, this.m_eps[i]);
                    this.m_fm[i] = this.newval(i, -this.m_eps[i]);
                }
            }
        } else {
            int i;
            if (!sym) {
                for (i = 0; i < n; ++i) {
                    this.m_eps[i] = this.m_fn.getDomain().epsilon(this.m_pt, i);
                    this.checkepsilon(i);
                }
            } else {
                this.m_fm = new double[n];
                for (i = 0; i < n; ++i) {
                    this.m_eps[i] = this.m_fn.getDomain().epsilon(this.m_pt, i);
                    this.checkepsilon(i);
                }
            }
            List<Callable<Void>> tasks = this.createTasks(n, sym);
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
            try {
                executorService.invokeAll(tasks);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            executorService.shutdown();
        }
    }

    private void calcgrad() {
        int n = this.m_fn.getDomain().getDim();
        this.m_grad = new double[n];
        for (int i = 0; i < n; ++i) {
            this.m_grad[i] = this.m_fp[i] == this.m_fcur ? 0.0 : (this.m_fm == null ? (this.m_fp[i] - this.m_fcur) / this.m_eps[i] : (this.m_fp[i] - this.m_fm[i]) / (2.0 * this.m_eps[i]));
        }
    }

    private void calch() {
        int i;
        int n = this.m_fn.getDomain().getDim();
        double[] e = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            e[i2] = Math.sqrt(Math.abs(this.m_eps[i2]));
        }
        this.m_h = new Matrix(n, n);
        DataBlock diag = this.m_h.diagonal();
        for (i = 0; i < n; ++i) {
            double di = e[i];
            double num = this.newval(i, di) - 2.0 * this.m_fcur + this.newval(i, -di);
            if (num == 0.0 || this.m_eps[i] == 0.0) continue;
            diag.set(i, num / (di * di));
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double di = e[i];
                double dj = e[j];
                double num = this.newval(i, j, di / 2.0, dj / 2.0) + this.newval(i, j, -di / 2.0, -dj / 2.0) - this.newval(i, j, di / 2.0, -dj / 2.0) - this.newval(i, j, -di / 2.0, dj / 2.0);
                if (num == 0.0 || di == 0.0 || dj == 0.0) continue;
                this.m_h.set(i, j, num / (di * dj));
            }
        }
        SymmetricMatrix.fromLower(this.m_h);
    }

    private void checkepsilon(int i) {
        double eps = this.m_eps[i];
        if (eps == 0.0) {
            return;
        }
        DataBlock pcur = new DataBlock(this.m_pt);
        double pi = pcur.get(i);
        pcur.add(i, eps);
        if (this.m_fn.getDomain().checkBoundaries(pcur)) {
            return;
        }
        int k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= g_nsteps && !this.m_fn.getDomain().checkBoundaries(pcur));
        if (k <= g_nsteps) {
            this.m_eps[i] = eps;
            return;
        }
        eps = -this.m_eps[i];
        pcur.set(i, pi + eps);
        if (this.m_fn.getDomain().checkBoundaries(pcur)) {
            this.m_eps[i] = eps;
            return;
        }
        k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= g_nsteps && !this.m_fn.getDomain().checkBoundaries(pcur));
        if (k <= g_nsteps) {
            this.m_eps[i] = eps;
            return;
        }
        this.m_eps[i] = 0.0;
    }

    @Override
    public double[] getGradient() {
        if (this.m_grad == null) {
            this.calcgrad();
        }
        return this.m_grad;
    }

    @Override
    public Matrix getHessian() {
        if (this.m_h == null) {
            this.calch();
        }
        return this.m_h;
    }

    private double newval(int i, double dx) {
        try {
            DataBlock cur = new DataBlock(this.m_pt);
            cur.add(i, dx);
            IFunctionInstance fn = this.m_fn.evaluate(cur);
            return fn.getValue();
        }
        catch (Exception err) {
            return this.m_fcur;
        }
    }

    private double newval(int i, int j, double dxi, double dxj) {
        try {
            DataBlock cur = new DataBlock(this.m_pt);
            cur.add(i, dxi);
            cur.add(j, dxj);
            IFunctionInstance fn = this.m_fn.evaluate(cur);
            return fn.getValue();
        }
        catch (Exception err) {
            return this.m_fcur;
        }
    }

    private List<Callable<Void>> createTasks(int n, boolean sym) {
        int i;
        ArrayList<Callable<Void>> result = new ArrayList<Callable<Void>>();
        for (i = 0; i < n; ++i) {
            result.add(new NewVal(this.m_fp, i, this.m_eps[i]));
        }
        if (sym) {
            for (i = 0; i < n; ++i) {
                result.add(new NewVal(this.m_fm, i, -this.m_eps[i]));
            }
        }
        return result;
    }

    private class NewVal
    implements Callable<Void> {
        double[] rslt;
        int pos;
        double eps;

        private NewVal(double[] rslt, int pos, double eps) {
            this.rslt = rslt;
            this.pos = pos;
            this.eps = eps;
        }

        @Override
        public Void call() throws Exception {
            try {
                DataBlock cur = new DataBlock(NumericalDerivatives.this.m_pt);
                cur.add(this.pos, this.eps);
                IFunctionInstance fn = NumericalDerivatives.this.m_fn.evaluate(cur);
                this.rslt[this.pos] = fn.getValue();
            }
            catch (Exception err) {
                this.rslt[this.pos] = NumericalDerivatives.this.m_fcur;
            }
            return null;
        }
    }
}

