/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.IntOption;
import java.util.Random;
import moa.core.Example;
import moa.core.ObjectRepository;
import moa.streams.ConceptDriftStream;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class RecurrentConceptDriftStream
extends ConceptDriftStream {
    private static final long serialVersionUID = 1L;
    public IntOption widthRecurrenceOption = new IntOption("widthRecurrence", 'x', "Number of instances during which new concept is used", 100);
    public IntOption stabPeriodOption = new IntOption("stabPeriod", 'y', "Number of instances between drifts", 200);
    public IntOption numRepOption = new IntOption("numRep", 'z', "Number of instances between drifts", 4);

    @Override
    public String getPurposeString() {
        return "Adds Recurrent Concept Drift to examples in a stream.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.inputStream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        this.driftStream = (InstanceStream)this.getPreparedClassOption(this.driftstreamOption);
        this.random = new Random(this.randomSeedOption.getValue());
        this.numberInstanceStream = 0;
        if (this.alphaOption.getValue() != 0.0) {
            this.widthOption.setValue((int)(1.0 / Math.tan(this.alphaOption.getValue() * Math.PI / 180.0)));
        }
    }

    @Override
    public Example nextInstance() {
        ++this.numberInstanceStream;
        double x = this.numberInstanceStream;
        double probabilityDrift = 0.0;
        int iPos = this.positionOption.getValue();
        for (int iNumRep = 0; iNumRep < this.numRepOption.getValue(); ++iNumRep) {
            probabilityDrift += 1.0 / (1.0 + Math.exp(-4.0 * (x - (double)iPos) / (double)this.widthOption.getValue())) - 1.0 / (1.0 + Math.exp(-4.0 * (x - (double)(iPos + this.widthRecurrenceOption.getValue())) / (double)this.widthOption.getValue()));
            iPos += this.widthRecurrenceOption.getValue() + this.stabPeriodOption.getValue();
        }
        if (this.random.nextDouble() > probabilityDrift) {
            return this.inputStream.nextInstance();
        }
        return this.driftStream.nextInstance();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

