/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.anomalydetection.probabilityfunctions;

import moa.classifiers.rules.core.anomalydetection.probabilityfunctions.ProbabilityFunction;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class GaussInequality
extends AbstractOptionHandler
implements ProbabilityFunction {
    private static final long serialVersionUID = 1L;
    private static final double SQRT3 = Math.sqrt(3.0);

    @Override
    public double getProbability(double mean, double sd, double value) {
        double k;
        if (sd == 0.0) {
            sd = 1.0E-7;
        }
        if ((k = Math.abs(value - mean) / sd) > 2.0 / SQRT3) {
            return 4.0 / (9.0 * Math.pow(k, 2.0));
        }
        return 1.0 - k / SQRT3;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

