/*
 * Decompiled with CFR 0.152.
 */
package dmLab.discretizer.change;

import dmLab.discretizer.Discretizer;
import dmLab.discretizer.DiscretizerParams;
import dmLab.discretizer.change.CutPoints;
import dmLab.discretizer.change.Event;
import dmLab.utils.MathUtils;
import java.util.Arrays;
import java.util.HashMap;

public class DiscChange
extends Discretizer {
    /*
     * WARNING - void declaration
     */
    @Override
    public float[] findRanges(float[] values, float[] decision, DiscretizerParams discParams) {
        void var1_1;
        void var2_2;
        void var3_4;
        int intervals = discParams.discIntervals;
        if (values.length < var3_4) {
            this.ranges = null;
            return this.getRanges();
        }
        Event[] eventArray = DiscChange.getEvents(values, decision);
        decision = eventArray;
        CutPoints cPoints = DiscChange.calcCutPoints(eventArray);
        this.ranges = var2_2.getValues();
        this.ranges.add(Float.valueOf(MathUtils.maxValue((float[])var1_1)));
        return this.getRanges();
    }

    protected static CutPoints calcCutPoints(Event[] events) {
        int first = 0;
        int classes = 0;
        int cutPointsNumber = 0;
        HashMap<Float, Integer> map = new HashMap<Float, Integer>();
        boolean ambiguity = false;
        for (int i = 0; i < events.length; ++i) {
            if (Float.isNaN(events[i].value)) {
                ++first;
            } else if (map.get(Float.valueOf(events[i].classIndex)) == null) {
                map.put(Float.valueOf(events[i].classIndex), classes++);
            }
            if (i <= first) continue;
            if (events[i].classIndex != events[i - 1].classIndex && events[i].value == events[i - 1].value) {
                ambiguity = true;
            }
            if (!(ambiguity && events[i].value > events[i - 1].value) && (ambiguity || events[i].classIndex == events[i - 1].classIndex)) continue;
            ++cutPointsNumber;
            ambiguity = false;
        }
        CutPoints cPoints = new CutPoints(cutPointsNumber + 1, classes);
        int[] classEvents = new int[classes];
        Arrays.fill(classEvents, 0);
        int cuts = 0;
        ambiguity = false;
        for (int i = first + 1; i < events.length; ++i) {
            if (events[i].value != events[i - 1].value) {
                ++cuts;
            }
            if (events[i].classIndex != events[i - 1].classIndex && events[i].value == events[i - 1].value) {
                ambiguity = true;
            }
            if (ambiguity && events[i].value > events[i - 1].value || !ambiguity && events[i].classIndex != events[i - 1].classIndex) {
                float cutPoint = events[i - 1].value + (events[i].value - events[i - 1].value) / 2.0f;
                int n = (Integer)map.get(Float.valueOf(events[i - 1].classIndex));
                classEvents[n] = classEvents[n] + 1;
                cPoints.add(cutPoint, i - 1, classEvents, cuts);
                Arrays.fill(classEvents, 0);
                boolean bl = false;
                cuts = 0;
            } else {
                int n = (Integer)map.get(Float.valueOf(events[i - 1].classIndex));
                classEvents[n] = classEvents[n] + 1;
            }
            if (i != events.length - 1) continue;
            int n = (Integer)map.get(Float.valueOf(events[i - 1].classIndex));
            classEvents[n] = classEvents[n] + 1;
            cPoints.add(events[i].value, i, classEvents, cuts);
        }
        return cPoints;
    }

    /*
     * WARNING - void declaration
     */
    protected static Event[] getEvents(float[] values, float[] decision) {
        void var2_2;
        Object[] events = new Event[values.length];
        for (int i = 0; i < values.length; ++i) {
            events[i] = new Event(values[i], decision[i]);
        }
        Arrays.sort(events);
        return var2_2;
    }
}

