/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.timeseries;

import java.time.LocalDate;
import java.util.List;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataTable;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticInfo;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.RevisionHistory;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Revisions<T extends Explorable> {
    private final RevisionHistory<T> revisions;

    public TsDomain referenceDomain() {
        return this.revisions.getReferenceDomain();
    }

    public T result(String period) {
        LocalDate date = LocalDate.parse(period);
        TsDomain referenceDomain = this.revisions.getReferenceDomain();
        int id = referenceDomain.indexOf(date.atStartOfDay());
        if (id < 0) {
            return null;
        }
        TsDomain cur = referenceDomain.range(0, id + 1);
        return (T)((Explorable)this.revisions.tsInfo(cur));
    }

    public TsData history(String id, String start) {
        LocalDate date = LocalDate.parse(start);
        TsDomain referenceDomain = this.revisions.getReferenceDomain();
        TsPeriod pstart = TsPeriod.of((TsUnit)referenceDomain.getTsUnit(), (LocalDate)date);
        return this.revisions.revision(pstart, rslt -> Revisions.toDouble(rslt.getData(id, Object.class)));
    }

    public TsData tsHistory(String id, String period, String start) {
        LocalDate date = LocalDate.parse(start);
        LocalDate refDate = LocalDate.parse(period);
        TsDomain referenceDomain = this.revisions.getReferenceDomain();
        TsPeriod pstart = TsPeriod.of((TsUnit)referenceDomain.getTsUnit(), (LocalDate)date);
        TsPeriod pref = TsPeriod.of((TsUnit)referenceDomain.getTsUnit(), (LocalDate)refDate);
        return this.revisions.tsRevision(pref, pstart, rslt -> (TsData)rslt.getData(id, TsData.class));
    }

    public TsDataTable tsSelect(String id, String start, String end) {
        LocalDate d0 = LocalDate.parse(start);
        LocalDate d1 = LocalDate.parse(end);
        List sel = this.revisions.select(d0, d1, r -> (TsData)r.getData(id, TsData.class));
        TsDataTable table = TsDataTable.of((Iterable)sel);
        return table;
    }

    public TsDomain referenceDomain(String id) {
        TsData data = (TsData)((Explorable)this.revisions.getReferenceInfo()).getData(id, TsData.class);
        return data == null ? null : data.getDomain();
    }

    public TsData diagnosticOf(String id, String start, String end, String diag) {
        TsPeriod p1;
        LocalDate d0 = LocalDate.parse(start);
        LocalDate d1 = LocalDate.parse(end);
        TsUnit unit = this.revisions.getReferenceDomain().getTsUnit();
        TsPeriod p0 = TsPeriod.of((TsUnit)unit, (LocalDate)d0);
        TsDomain domain = TsDomain.of((TsPeriod)p0, (int)(p0.until(p1 = TsPeriod.of((TsUnit)unit, (LocalDate)d1)) + 1));
        if (domain.isEmpty()) {
            return null;
        }
        DiagnosticInfo info = DiagnosticInfo.valueOf((String)diag);
        double[] revs = new double[domain.length()];
        for (int i = 0; i < revs.length; ++i) {
            revs[i] = this.revisions.seriesRevision(p0.plus((long)i), info, rslt -> (TsData)rslt.getData(id, TsData.class));
        }
        return TsData.ofInternal((TsPeriod)p0, (double[])revs);
    }

    public static double toDouble(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Double) {
            Double dobj = (Double)obj;
            return dobj;
        }
        if (obj instanceof Integer) {
            Integer iobj = (Integer)obj;
            return iobj.doubleValue();
        }
        if (obj instanceof Boolean) {
            Boolean bobj = (Boolean)obj;
            return bobj != false ? 1.0 : 0.0;
        }
        if (obj instanceof StatisticalTest) {
            StatisticalTest tobj = (StatisticalTest)obj;
            return tobj.getPvalue();
        }
        if (obj instanceof RegressionItem) {
            RegressionItem robj = (RegressionItem)obj;
            return robj.getCoefficient();
        }
        if (obj instanceof double[]) {
            double[] aobj = (double[])obj;
            return aobj.length == 1 ? aobj[0] : Double.NaN;
        }
        return Double.NaN;
    }

    @Generated
    public Revisions(RevisionHistory<T> revisions) {
        this.revisions = revisions;
    }

    @Generated
    public RevisionHistory<T> getRevisions() {
        return this.revisions;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Revisions)) {
            return false;
        }
        Revisions other = (Revisions)o;
        RevisionHistory<T> this$revisions = this.getRevisions();
        RevisionHistory<T> other$revisions = other.getRevisions();
        return !(this$revisions == null ? other$revisions != null : !this$revisions.equals(other$revisions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevisionHistory<T> $revisions = this.getRevisions();
        result = result * 59 + ($revisions == null ? 43 : $revisions.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Revisions(revisions=" + String.valueOf(this.getRevisions()) + ")";
    }
}

