/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.variables.Variable;

public interface PropagationInsight {
    public static final PropagationInsight VOID = new PropagationInsight(){};

    default public void clear() {
    }

    default public void cardinality(Propagator<?> p) {
    }

    default public void update(Propagator<?> p, Variable v, boolean onFailure) {
    }

    default public void modifiy(Variable v) {
    }

    public static class PickOnFil
    implements PropagationInsight {
        private final ArrayList<Propagator<?>> Lcstrs = new ArrayList();
        private final TLongArrayList Ldeltas = new TLongArrayList();
        private long card;
        private boolean changed;

        @Override
        public void clear() {
            this.Lcstrs.clear();
            this.Ldeltas.resetQuick();
        }

        @Override
        public void cardinality(Propagator<?> p) {
            this.card = 0L;
            for (int j = 0; j < p.getNbVars(); ++j) {
                this.card += (long)p.getVar(j).getDomainSize();
            }
        }

        @Override
        public void update(Propagator<?> p, Variable v, boolean onFailure) {
            if (!this.changed && !onFailure) {
                return;
            }
            this.changed = false;
            if (!onFailure) {
                long card_ = this.card;
                this.cardinality(p);
                this.card = card_ - this.card;
            }
            this.Lcstrs.add(p);
            this.Ldeltas.add(this.card);
        }

        @Override
        public void modifiy(Variable v) {
            this.changed = true;
        }

        public ArrayList<Propagator<?>> getLcstrs() {
            return this.Lcstrs;
        }

        public TLongArrayList getLdeltas() {
            return this.Ldeltas;
        }
    }

    public static class PickOnDom
    implements PropagationInsight {
        private final ArrayList<Variable> Lvars = new ArrayList();
        private final TLongArrayList Ldeltas = new TLongArrayList();
        private long card;
        private boolean changed;

        @Override
        public void clear() {
            this.Lvars.clear();
            this.Ldeltas.resetQuick();
        }

        @Override
        public void cardinality(Propagator<?> p) {
            this.card = 0L;
            for (int j = 0; j < p.getNbVars(); ++j) {
                this.card += (long)p.getVar(j).getDomainSize();
            }
        }

        @Override
        public void update(Propagator<?> p, Variable v, boolean onFailure) {
            if (!this.changed && !onFailure) {
                return;
            }
            this.changed = false;
            if (!onFailure) {
                long card_ = this.card;
                this.cardinality(p);
                this.card = card_ - this.card;
            }
            this.Lvars.add(v);
            this.Ldeltas.add(this.card);
        }

        @Override
        public void modifiy(Variable v) {
            this.changed = true;
        }

        public ArrayList<Variable> getLvars() {
            return this.Lvars;
        }

        public TLongArrayList getLdeltas() {
            return this.Ldeltas;
        }
    }
}

