/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

final class ConjugatedAtomEncoder
implements AtomEncoder {
    private final List<AtomEncoder> encoders;

    public ConjugatedAtomEncoder(List<AtomEncoder> encoders) {
        if (encoders == null) {
            throw new NullPointerException("null list of encoders");
        }
        if (encoders.isEmpty()) {
            throw new IllegalArgumentException("no encoders provided");
        }
        this.encoders = Collections.unmodifiableList(new ArrayList<AtomEncoder>(encoders));
    }

    public int encode(IAtom atom, IAtomContainer container) {
        int hash = 179426549;
        for (AtomEncoder encoder : this.encoders) {
            hash = 31 * hash + encoder.encode(atom, container);
        }
        return hash;
    }

    public static AtomEncoder create(AtomEncoder encoder, AtomEncoder ... encoders) {
        if (encoder == null || encoders == null) {
            throw new NullPointerException("null encoders provided");
        }
        ArrayList<AtomEncoder> tmp = new ArrayList<AtomEncoder>(encoders.length + 1);
        tmp.add(encoder);
        for (AtomEncoder e : encoders) {
            tmp.add(e);
        }
        return new ConjugatedAtomEncoder(tmp);
    }
}

