/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import epp.EPPLab;
import epp.EvolutionPP;
import epp.ParametrePP;
import ihm.Analyse;
import ihm.Ihm;
import ihm.controle.JDialogFichier;
import ihm.controle.JTextNbIndividus;
import ihm.controle.JTextNbIterations;
import ihm.controle.JTextNbSimulations;
import ihm.graphique.ConvergenceIndice;
import ihm.graphique.EstimateurNoyau;
import ihm.graphique.Histogramme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javalain.algorithmegenetique.ihm.composant.JButtonEA;
import javalain.algorithmegenetique.ihm.composant.JComboBoxEA;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPar;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPres;
import javalain.algorithmegenetique.ihm.composant.JRadioButtonEA;
import javalain.algorithmegenetique.ihm.composant.TitledBorderEA;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import util.GuiUtils;
import util.StringUtils;

public class Recherche
extends JFrame
implements ItemListener {
    private Ihm frIhm;
    private JLabelEAPres lblSearchGroupe;
    private JRadioButtonEA rbGKurtosisMin;
    private JRadioButtonEA rbGFriedman;
    private JRadioButtonEA rbGDiscriminant;
    private JLabelEAPres lblSearchAtypique;
    private JRadioButtonEA rbKurtosisMax;
    private JRadioButtonEA rbFriedman;
    private JRadioButtonEA rbFriedmanTukey;
    private JRadioButtonEA rbDiscriminant;
    private JRadioButtonEA rbIndice4;
    private JRadioButtonEA rbStahelDonoho;
    private JLabelEAPres lblTypeM;
    private JRadioButtonEA rbGA;
    private JRadioButtonEA rbPSO;
    private JRadioButtonEA rbTribes;
    private JRadioButtonEA rbMultiStart;
    private JLabelEAPres lblParametres;
    private JLabelEAPar lblIndividus;
    private JLabelEAPar lblIterations;
    private JTextNbIndividus txtNbIndividus;
    private JTextNbIterations txtNbIterations;
    private JLabelEAPres lblDonnees;
    private JRadioButtonEA rbDNon;
    private JRadioButtonEA rbDOui;
    private JButtonEA btLecture;
    private JButtonEA btSuivant;
    private JButtonEA btStop;
    private JRadioButtonEA rbVisuFin;
    private JRadioButtonEA rbVisuLancement;
    private JRadioButtonEA rbVisuIteration;
    private JRadioButtonEA rbHistogramme;
    private JRadioButtonEA rbEstimateur;
    private JTextNbSimulations txtNbLancements;
    private JLabelEAPar lblEnCours;
    private JLabelEAPar lblTemps;
    private JPanel jpGraph;
    private Histogramme histogramme;
    private EstimateurNoyau estimateurNoyau;
    private ConvergenceIndice courbe;
    private final ImageIcon play = new ImageIcon(this.getClass().getResource("icone/play.gif"));
    private final ImageIcon pause = new ImageIcon(this.getClass().getResource("icone/pause.gif"));
    private JButtonEA btRetour;
    private JButtonEA btAnalyse;
    private JComboBoxEA cbListeSortie;
    private boolean stepByStep = false;
    private EvolutionPP evolution;
    private ParametrePP parametre;

    public Recherche(int x, int y, EvolutionPP e, ParametrePP p, Ihm f) {
        this.setLocation(x, y);
        this.setResizable(false);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                EPPLab.savePrefs(Recherche.this.parametre, Recherche.this.getX(), Recherche.this.getY());
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Recherche.this.cbListeSortie.updateUI();
            }
        });
        this.evolution = e;
        this.evolution.setFrRecherche(this);
        this.parametre = p;
        this.frIhm = f;
        Container conteneur = this.getContentPane();
        conteneur.setLayout(new BoxLayout(conteneur, 1));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel jpNord = new JPanel();
        jpNord.setLayout(new BoxLayout(jpNord, 0));
        JPanel jpIndice = new JPanel();
        jpIndice.setLayout(gb);
        jpIndice.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.indice")));
        int ligne = 0;
        Component espace = Box.createHorizontalStrut(125);
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 23;
        gb.setConstraints(espace, gbc);
        jpIndice.add(espace);
        this.lblSearchGroupe = new JLabelEAPres(EPPLab.msg.getString("label.searchGroupe"));
        gb.setConstraints(this.lblSearchGroupe, gbc);
        jpIndice.add(this.lblSearchGroupe);
        ButtonGroup groupSearch = new ButtonGroup();
        this.rbGKurtosisMin = new JRadioButtonEA("Kurtosis Min");
        this.rbGKurtosisMin.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.rbGKurtosisMin, gbc);
        jpIndice.add(this.rbGKurtosisMin);
        groupSearch.add(this.rbGKurtosisMin);
        this.rbGFriedman = new JRadioButtonEA("Friedman");
        this.rbGFriedman.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.rbGFriedman, gbc);
        jpIndice.add(this.rbGFriedman);
        groupSearch.add(this.rbGFriedman);
        this.rbGDiscriminant = new JRadioButtonEA("Discriminant");
        this.rbGDiscriminant.addItemListener(this);
        gbc.gridy = ligne;
        gb.setConstraints(this.rbGDiscriminant, gbc);
        jpIndice.add(this.rbGDiscriminant);
        groupSearch.add(this.rbGDiscriminant);
        ligne = 0;
        this.lblSearchAtypique = new JLabelEAPres(EPPLab.msg.getString("label.searchAtypique"));
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.lblSearchAtypique, gbc);
        jpIndice.add(this.lblSearchAtypique);
        this.rbKurtosisMax = new JRadioButtonEA("Kurtosis Max");
        this.rbKurtosisMax.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(this.rbKurtosisMax, gbc);
        jpIndice.add(this.rbKurtosisMax);
        groupSearch.add(this.rbKurtosisMax);
        this.rbFriedman = new JRadioButtonEA("Friedman");
        this.rbFriedman.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0A00;
        gb.setConstraints(this.rbFriedman, gbc);
        jpIndice.add(this.rbFriedman);
        groupSearch.add(this.rbFriedman);
        this.rbFriedmanTukey = new JRadioButtonEA("Friedman Tukey");
        this.rbFriedmanTukey.addItemListener(this);
        gbc.gridy = ligne++;
        gb.setConstraints(this.rbFriedmanTukey, gbc);
        jpIndice.add(this.rbFriedmanTukey);
        groupSearch.add(this.rbFriedmanTukey);
        this.rbDiscriminant = new JRadioButtonEA("Discriminant");
        this.rbDiscriminant.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gb.setConstraints(this.rbDiscriminant, gbc);
        jpIndice.add(this.rbDiscriminant);
        groupSearch.add(this.rbDiscriminant);
        this.rbIndice4 = new JRadioButtonEA("Indice 4");
        this.rbIndice4.setVisible(false);
        this.rbIndice4.addItemListener(this);
        gbc.gridy = ligne++;
        gb.setConstraints(this.rbIndice4, gbc);
        jpIndice.add(this.rbIndice4);
        groupSearch.add(this.rbIndice4);
        this.rbStahelDonoho = new JRadioButtonEA("Stahel Donoho");
        this.rbStahelDonoho.setVisible(false);
        this.rbStahelDonoho.addItemListener(this);
        gbc.gridy = ligne;
        gb.setConstraints(this.rbStahelDonoho, gbc);
        jpIndice.add(this.rbStahelDonoho);
        groupSearch.add(this.rbStahelDonoho);
        jpNord.add(jpIndice);
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel jpMethode = new JPanel();
        jpMethode.setLayout(gb);
        jpMethode.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.methode")));
        ligne = 0;
        this.lblTypeM = new JLabelEAPres(EPPLab.msg.getString("label.typeM"));
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 23;
        gb.setConstraints(this.lblTypeM, gbc);
        jpMethode.add(this.lblTypeM);
        ButtonGroup groupMethode = new ButtonGroup();
        this.rbGA = new JRadioButtonEA(EPPLab.msg.getString("rb.GA"));
        this.rbGA.addItemListener(this);
        this.rbGA.setToolTipText(EPPLab.msg.getString("nom.GA"));
        gbc.gridy = ligne;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.rbGA, gbc);
        jpMethode.add(this.rbGA);
        groupMethode.add(this.rbGA);
        this.rbTribes = new JRadioButtonEA(EPPLab.msg.getString("rb.TRIBES"));
        this.rbTribes.addItemListener(this);
        this.rbTribes.setToolTipText(EPPLab.msg.getString("nom.TRIBES"));
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.rbTribes, gbc);
        jpMethode.add(this.rbTribes);
        groupMethode.add(this.rbTribes);
        this.rbPSO = new JRadioButtonEA(EPPLab.msg.getString("rb.PSO"));
        this.rbPSO.addItemListener(this);
        this.rbPSO.setToolTipText(EPPLab.msg.getString("nom.PSO"));
        gbc.gridx = 0;
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.rbPSO, gbc);
        jpMethode.add(this.rbPSO);
        groupMethode.add(this.rbPSO);
        this.rbMultiStart = new JRadioButtonEA(EPPLab.msg.getString("rb.MULTISTART"));
        this.rbMultiStart.setVisible(true);
        this.rbMultiStart.addItemListener(this);
        this.rbMultiStart.setToolTipText(EPPLab.msg.getString("nom.MULTISTART"));
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.rbMultiStart, gbc);
        groupMethode.add(this.rbMultiStart);
        this.lblParametres = new JLabelEAPres(EPPLab.msg.getString("label.parametres"));
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 0, 0, 0);
        gb.setConstraints(this.lblParametres, gbc);
        jpMethode.add(this.lblParametres);
        this.lblIndividus = new JLabelEAPar(EPPLab.msg.getString("label.individu"));
        gbc.gridy = ligne;
        gbc.insets = new Insets(4, 5, 0, 0);
        gbc.anchor = 512;
        gb.setConstraints(this.lblIndividus, gbc);
        jpMethode.add(this.lblIndividus);
        if (this.rbPSO.isSelected()) {
            this.lblIndividus.setText(EPPLab.msg.getString("label.particule"));
        }
        this.txtNbIndividus = new JTextNbIndividus(this);
        this.txtNbIndividus.setText("" + p.getNbIndividus());
        gbc.gridx = 2;
        gb.setConstraints(this.txtNbIndividus, gbc);
        jpMethode.add(this.txtNbIndividus);
        this.lblIterations = new JLabelEAPar(EPPLab.msg.getString("label.iteration"));
        gbc.gridx = 0;
        gbc.gridy = ++ligne;
        gbc.insets = new Insets(2, 5, 0, 0);
        gb.setConstraints(this.lblIterations, gbc);
        jpMethode.add(this.lblIterations);
        this.txtNbIterations = new JTextNbIterations(this);
        this.txtNbIterations.setText("" + p.getNbIterations());
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gb.setConstraints(this.txtNbIterations, gbc);
        jpMethode.add(this.txtNbIterations);
        jpNord.add(jpMethode);
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel jpDonnees = new JPanel();
        jpDonnees.setLayout(gb);
        jpDonnees.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.donnees")));
        ligne = 0;
        this.lblDonnees = new JLabelEAPres(EPPLab.msg.getString("label.donneesSpheriques"));
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 23;
        gb.setConstraints(this.lblDonnees, gbc);
        jpDonnees.add(this.lblDonnees);
        ButtonGroup groupDonnees = new ButtonGroup();
        this.rbDOui = new JRadioButtonEA(EPPLab.msg.getString("rb.oui"));
        this.rbDOui.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.rbDOui, gbc);
        jpDonnees.add(this.rbDOui);
        groupDonnees.add(this.rbDOui);
        this.rbDNon = new JRadioButtonEA(EPPLab.msg.getString("rb.non"));
        this.rbDNon.addItemListener(this);
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0500;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gb.setConstraints(this.rbDNon, gbc);
        jpDonnees.add(this.rbDNon);
        groupDonnees.add(this.rbDNon);
        jpNord.add(jpDonnees);
        conteneur.add(jpNord);
        JPanel jpSud = new JPanel();
        jpSud.setLayout(new BoxLayout(jpSud, 0));
        gb = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel jpVisualisation = new JPanel();
        jpVisualisation.setLayout(gb);
        jpVisualisation.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.visualisation")));
        ligne = 0;
        JLabelEAPres lblNavigation = new JLabelEAPres(EPPLab.msg.getString("label.navigation"));
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 23;
        gb.setConstraints(lblNavigation, gbc);
        jpVisualisation.add(lblNavigation);
        JPanel jpNavigation = new JPanel();
        jpNavigation.setLayout(GuiUtils.FL_LEFT_00);
        gbc.gridy = ligne;
        gbc.gridheight = 3;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(jpNavigation, gbc);
        this.btLecture = new JButtonEA(this.play);
        this.btLecture.setToolTipText(EPPLab.msg.getString("bt.lecture"));
        jpNavigation.add(this.btLecture);
        this.btSuivant = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/suivant.gif")));
        this.btSuivant.setToolTipText(EPPLab.msg.getString("bt.suivant"));
        jpNavigation.add(this.btSuivant);
        this.btStop = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/stop.gif")));
        this.btStop.setEnabled(false);
        this.btStop.setToolTipText(EPPLab.msg.getString("bt.stop"));
        jpNavigation.add(this.btStop);
        jpVisualisation.add(jpNavigation);
        ligne = 0;
        JLabelEAPres lblVisualisation = new JLabelEAPres(EPPLab.msg.getString("label.visualisation"));
        gbc.gridx = 1;
        gbc.gridy = ligne++;
        gbc.gridheight = 1;
        gbc.insets = GuiUtils.INSETS_0500;
        gbc.anchor = 512;
        gb.setConstraints(lblVisualisation, gbc);
        jpVisualisation.add(lblVisualisation);
        ButtonGroup groupVisualisation = new ButtonGroup();
        this.rbVisuFin = new JRadioButtonEA(EPPLab.msg.getString("rb.visuFin"));
        this.rbVisuFin.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(this.rbVisuFin, gbc);
        jpVisualisation.add(this.rbVisuFin);
        groupVisualisation.add(this.rbVisuFin);
        this.rbVisuLancement = new JRadioButtonEA(EPPLab.msg.getString("rb.visuLancement"));
        this.rbVisuLancement.addItemListener(this);
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0A00;
        gb.setConstraints(this.rbVisuLancement, gbc);
        jpVisualisation.add(this.rbVisuLancement);
        groupVisualisation.add(this.rbVisuLancement);
        this.rbVisuIteration = new JRadioButtonEA(EPPLab.msg.getString("rb.visuIteration"));
        this.rbVisuIteration.addItemListener(this);
        gbc.gridy = ligne;
        gbc.weighty = 1.0;
        gb.setConstraints(this.rbVisuIteration, gbc);
        jpVisualisation.add(this.rbVisuIteration);
        groupVisualisation.add(this.rbVisuIteration);
        gbc.weighty = 0.0;
        ligne = 0;
        JLabelEAPres lblGraphiques = new JLabelEAPres(EPPLab.msg.getString("label.graphique"));
        gbc.gridx = 2;
        gbc.gridy = ligne++;
        gbc.gridheight = 1;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(lblGraphiques, gbc);
        jpVisualisation.add(lblGraphiques);
        ButtonGroup groupGraph = new ButtonGroup();
        this.rbHistogramme = new JRadioButtonEA(EPPLab.msg.getString("label.histogramme"));
        this.rbHistogramme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Recherche.this.rbHistogramme.isSelected() && Recherche.this.estimateurNoyau != null) {
                    Recherche.this.jpGraph.remove(Recherche.this.estimateurNoyau);
                    if (Recherche.this.histogramme == null) {
                        Recherche.this.histogramme = new Histogramme(6, 3, false, false, null);
                        Recherche.this.histogramme.setFichierDonnees(((Recherche)Recherche.this).parametre.ficherDeDonnees);
                    }
                    Recherche.this.histogramme.setProjection(Recherche.this.estimateurNoyau.getDonnees());
                    Recherche.this.jpGraph.add((Component)Recherche.this.histogramme, 1);
                    Recherche.this.jpGraph.repaint();
                    Recherche.this.pack();
                }
            }
        });
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(this.rbHistogramme, gbc);
        jpVisualisation.add(this.rbHistogramme);
        groupGraph.add(this.rbHistogramme);
        this.rbEstimateur = new JRadioButtonEA(EPPLab.msg.getString("label.estimateur"));
        this.rbEstimateur.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Recherche.this.rbEstimateur.isSelected() && Recherche.this.histogramme != null) {
                    Recherche.this.jpGraph.remove(Recherche.this.histogramme);
                    if (Recherche.this.estimateurNoyau == null) {
                        Recherche.this.estimateurNoyau = new EstimateurNoyau(6, 3, false, false, null);
                    }
                    Recherche.this.estimateurNoyau.setProjection(Recherche.this.histogramme.getDonnees());
                    Recherche.this.jpGraph.add((Component)Recherche.this.estimateurNoyau, 1);
                    Recherche.this.jpGraph.repaint();
                    Recherche.this.pack();
                }
            }
        });
        gbc.gridy = ligne;
        gbc.insets = GuiUtils.INSETS_0A00;
        gb.setConstraints(this.rbEstimateur, gbc);
        jpVisualisation.add(this.rbEstimateur);
        groupGraph.add(this.rbEstimateur);
        ligne = 0;
        espace = Box.createHorizontalStrut(175);
        gbc.gridx = 3;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0000;
        gb.setConstraints(espace, gbc);
        jpVisualisation.add(espace);
        JLabelEAPres lblNbLancements = new JLabelEAPres(EPPLab.msg.getString("label.nbLancements"));
        gbc.weightx = 1.0;
        gb.setConstraints(lblNbLancements, gbc);
        jpVisualisation.add(lblNbLancements);
        gbc.weightx = 0.0;
        this.txtNbLancements = new JTextNbSimulations(this);
        this.txtNbLancements.setText("" + p.nbSimulation);
        gbc.gridx = 3;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(this.txtNbLancements, gbc);
        jpVisualisation.add(this.txtNbLancements);
        this.lblEnCours = new JLabelEAPar("");
        this.lblEnCours.setToolTipText(EPPLab.msg.getString("tiptext.enCours"));
        gbc.gridx = 3;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_0A00;
        gb.setConstraints(this.lblEnCours, gbc);
        jpVisualisation.add(this.lblEnCours);
        this.lblTemps = new JLabelEAPar("");
        this.lblTemps.setToolTipText(EPPLab.msg.getString("tiptext.temps"));
        gbc.gridx = 3;
        gbc.gridy = ligne;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5A00;
        gb.setConstraints(this.lblTemps, gbc);
        jpVisualisation.add(this.lblTemps);
        jpSud.add(jpVisualisation);
        JPanel jpCourbe = new JPanel();
        jpCourbe.setLayout(GuiUtils.FL_LEFT_00);
        jpCourbe.setBorder(new TitledBorderEA(EPPLab.msg.getString("tb.courbe")));
        this.courbe = new ConvergenceIndice(200, 100);
        jpCourbe.add(this.courbe);
        jpSud.add(jpCourbe);
        conteneur.add(jpSud);
        MouseAdapter read = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Recherche.this.execute();
                Recherche.this.btSuivant.setEnabled(false);
                Recherche.this.btStop.setEnabled(true);
                if (Recherche.this.btLecture.getIcon().equals(Recherche.this.play)) {
                    Recherche.this.btLecture.setIcon(Recherche.this.pause);
                    Recherche.this.btLecture.setToolTipText(EPPLab.msg.getString("bt.pause"));
                    if (Recherche.this.evolution.getEtat() == 3) {
                        Recherche.this.evolution.setEtat(2);
                    } else {
                        Recherche.this.evolution.setEtat(1);
                    }
                } else {
                    Recherche.this.btLecture.setIcon(Recherche.this.play);
                    Recherche.this.btLecture.setToolTipText(EPPLab.msg.getString("bt.lecture"));
                    Recherche.this.evolution.setEtat(3);
                }
            }
        };
        this.btLecture.addMouseListener(read);
        MouseAdapter next = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Recherche.this.execute();
                Recherche.this.stepByStep = true;
                Recherche.this.btLecture.setEnabled(false);
                Recherche.this.btSuivant.setEnabled(false);
                Recherche.this.btStop.setEnabled(true);
                Recherche.this.evolution.setEtat(1);
            }
        };
        this.btSuivant.addMouseListener(next);
        MouseAdapter arret = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Recherche.this.evolution.setEtat(4);
            }
        };
        this.btStop.addMouseListener(arret);
        JPanel jpCde = new JPanel();
        jpCde.setLayout(new BorderLayout());
        jpCde.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JButtonEA btAide = new JButtonEA(new ImageIcon(this.getClass().getResource("icone/help.gif")));
        btAide.setToolTipText(EPPLab.msg.getString("menu.aide"));
        btAide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(EPPLab.msg.getString("menu.aide"));
            }
        });
        jpCde.add((Component)btAide, "West");
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout(5, 0));
        jp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.btRetour = new JButtonEA(EPPLab.msg.getString("menu.retour"));
        this.btRetour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recherche.this.setVisible(false);
                Recherche.this.frIhm.setVisible(true);
            }
        });
        jp.add((Component)this.btRetour, "West");
        this.cbListeSortie = new JComboBoxEA(this.frIhm.l_fichiers_sortie);
        this.cbListeSortie.setMaximumSize(new Dimension(350, 23));
        this.cbListeSortie.setPreferredSize(new Dimension(350, 23));
        this.cbListeSortie.setSelectedIndex(0);
        this.cbListeSortie.setEnabled(true);
        this.cbListeSortie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Recherche.this.cbListeSortie.getSelectedItem().equals(EPPLab.msg.getString("cb.listeSortie"))) {
                    Recherche.this.btAnalyse.setEnabled(false);
                } else {
                    Recherche.this.btAnalyse.setEnabled(true);
                }
            }
        });
        jp.add((Component)this.cbListeSortie, "Center");
        this.btAnalyse = new JButtonEA(EPPLab.msg.getString("bt.analyse"));
        this.btAnalyse.setEnabled(false);
        this.btAnalyse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Recherche.this.setVisible(false);
                if (((Recherche)Recherche.this).frIhm.frAnalyse == null) {
                    ((Recherche)Recherche.this).frIhm.frAnalyse = new Analyse(Recherche.this.getX(), Recherche.this.getY(), (String)Recherche.this.cbListeSortie.getSelectedItem(), Recherche.this.frIhm);
                }
                ((Recherche)Recherche.this).frIhm.frAnalyse.setVisible(true);
                ((Recherche)Recherche.this).frIhm.frAnalyse.initialise((String)Recherche.this.cbListeSortie.getSelectedItem());
            }
        });
        jp.add((Component)this.btAnalyse, "East");
        jpCde.add((Component)jp, "East");
        conteneur.add(jpCde);
        this.jpGraph = new JPanel();
        this.jpGraph.setLayout(new BoxLayout(this.jpGraph, 0));
        this.jpGraph.setBackground(GuiUtils.GRIS_238);
        this.jpGraph.setVisible(false);
        this.jpGraph.add(Box.createHorizontalGlue());
        this.getRootPane().setDefaultButton(this.btLecture);
        conteneur.add(this.jpGraph);
        this.pack();
        this.setVisible(true);
    }

    public ParametrePP getParametre() {
        return this.parametre;
    }

    public ConvergenceIndice getCourbeConvergence() {
        return this.courbe;
    }

    public boolean isVisuIteration() {
        return this.rbVisuIteration.isSelected();
    }

    public boolean isVisuLancement() {
        return this.rbVisuLancement.isSelected();
    }

    public boolean isVisuFin() {
        return this.rbVisuFin.isSelected();
    }

    public void endStepByStep() {
        this.stepByStep = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Recherche.this.btLecture.setEnabled(true);
                Recherche.this.btSuivant.setEnabled(true);
            }
        });
    }

    public boolean isStepByStep() {
        return this.stepByStep;
    }

    public void initialise() {
        this.setTitle(EPPLab.msg.getString("frame.nouvelleRecherche") + " '" + this.parametre.ficherDeDonnees + "'");
        if (this.frIhm.isModeExpert()) {
            this.lblSearchGroupe.setEnabled(true);
            this.rbGKurtosisMin.setEnabled(true);
            this.rbGFriedman.setEnabled(true);
            this.rbGDiscriminant.setEnabled(true);
            this.lblSearchAtypique.setEnabled(true);
            this.rbKurtosisMax.setEnabled(true);
            this.rbFriedman.setEnabled(true);
            this.rbFriedmanTukey.setEnabled(true);
            this.rbDiscriminant.setEnabled(true);
            this.rbIndice4.setEnabled(true);
            this.rbStahelDonoho.setEnabled(true);
            this.lblTypeM.setEnabled(true);
            this.rbGA.setEnabled(true);
            this.rbPSO.setEnabled(true);
            this.rbTribes.setEnabled(true);
            this.rbMultiStart.setEnabled(true);
            this.lblParametres.setEnabled(true);
            this.lblIndividus.setEnabled(!this.rbTribes.isSelected());
            this.txtNbIndividus.setEnabled(!this.rbTribes.isSelected());
            this.lblIterations.setEnabled(true);
            this.txtNbIterations.setEnabled(true);
            this.lblDonnees.setEnabled(true);
            this.rbDOui.setEnabled(true);
            this.rbDNon.setEnabled(true);
        } else if (this.frIhm.isModeDebutant()) {
            if (this.frIhm.isRechercheGroupe()) {
                this.lblSearchGroupe.setEnabled(true);
                this.rbGKurtosisMin.setEnabled(true);
                this.rbGFriedman.setEnabled(true);
                this.rbGDiscriminant.setEnabled(true);
                this.lblSearchAtypique.setEnabled(false);
                this.rbKurtosisMax.setEnabled(false);
                this.rbFriedman.setEnabled(false);
                this.rbFriedmanTukey.setEnabled(false);
                this.rbDiscriminant.setEnabled(false);
                this.rbIndice4.setEnabled(false);
                this.rbStahelDonoho.setEnabled(false);
            } else {
                this.lblSearchGroupe.setEnabled(false);
                this.rbGKurtosisMin.setEnabled(false);
                this.rbGFriedman.setEnabled(false);
                this.rbGDiscriminant.setEnabled(false);
                this.lblSearchAtypique.setEnabled(true);
                this.rbKurtosisMax.setEnabled(true);
                this.rbFriedman.setEnabled(true);
                this.rbFriedmanTukey.setEnabled(true);
                this.rbDiscriminant.setEnabled(true);
                this.rbIndice4.setEnabled(true);
                this.rbStahelDonoho.setEnabled(true);
            }
            this.lblTypeM.setEnabled(false);
            this.rbGA.setEnabled(false);
            this.rbPSO.setEnabled(false);
            this.rbTribes.setEnabled(false);
            this.rbMultiStart.setEnabled(false);
            this.lblParametres.setEnabled(false);
            this.lblIndividus.setEnabled(false);
            this.txtNbIndividus.setEnabled(false);
            this.lblIterations.setEnabled(false);
            this.txtNbIterations.setEnabled(false);
            this.lblDonnees.setEnabled(false);
            this.rbDOui.setEnabled(true);
            this.rbDNon.setEnabled(true);
        }
        if (this.frIhm.isRechercheGroupe()) {
            this.rbGKurtosisMin.setSelected(true);
        } else {
            this.rbKurtosisMax.setSelected(true);
        }
        if (this.parametre.methode == "Genetic Algorithm") {
            this.rbGA.setSelected(true);
        } else if (this.parametre.methode == "Particule Swarm Optimization") {
            this.rbPSO.setSelected(true);
        } else if (this.parametre.methode == "Tribes") {
            this.rbTribes.setSelected(true);
        }
        if (this.parametre.sphere) {
            this.rbDOui.setSelected(true);
        } else {
            this.rbDNon.setSelected(true);
        }
        this.rbVisuLancement.setSelected(true);
        this.rbEstimateur.setSelected(true);
        if (this.histogramme != null) {
            this.jpGraph.remove(this.histogramme);
            this.histogramme = null;
        }
        if (this.estimateurNoyau != null) {
            this.jpGraph.remove(this.estimateurNoyau);
            this.estimateurNoyau = null;
        }
        this.lblEnCours.setVisible(false);
        this.lblTemps.setVisible(false);
        this.cbListeSortie.setSelectedItem(EPPLab.msg.getString("cb.listeSortie"));
        this.pack();
        this.rbDOui.setSelected(true);
        this.rbTribes.setSelected(true);
        this.txtNbLancements.setValeur(200);
    }

    private void execute() {
        this.lblSearchGroupe.setEnabled(false);
        this.rbGKurtosisMin.setEnabled(false);
        this.rbGFriedman.setEnabled(false);
        this.rbGDiscriminant.setEnabled(false);
        this.lblSearchAtypique.setEnabled(false);
        this.rbKurtosisMax.setEnabled(false);
        this.rbFriedman.setEnabled(false);
        this.rbFriedmanTukey.setEnabled(false);
        this.rbDiscriminant.setEnabled(false);
        this.rbIndice4.setEnabled(false);
        this.rbStahelDonoho.setEnabled(false);
        this.lblTypeM.setEnabled(false);
        this.rbGA.setEnabled(false);
        this.rbPSO.setEnabled(false);
        this.rbTribes.setEnabled(false);
        this.rbMultiStart.setEnabled(false);
        this.lblParametres.setEnabled(false);
        this.lblIndividus.setEnabled(false);
        this.txtNbIndividus.setEnabled(false);
        this.lblIterations.setEnabled(false);
        this.txtNbIterations.setEnabled(false);
        this.lblDonnees.setEnabled(false);
        this.rbDOui.setEnabled(false);
        this.rbDNon.setEnabled(false);
        this.txtNbLancements.setEnabled(false);
        this.lblEnCours.setVisible(true);
        this.lblEnCours.setEnabled(true);
        this.lblTemps.setVisible(true);
        this.lblTemps.setEnabled(true);
        this.btRetour.setEnabled(false);
        this.cbListeSortie.setEnabled(false);
        this.pack();
    }

    public void termine(final String new_fich) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Recherche.this.frIhm.isModeExpert()) {
                    Recherche.this.lblSearchGroupe.setEnabled(true);
                    Recherche.this.rbGKurtosisMin.setEnabled(true);
                    Recherche.this.rbGFriedman.setEnabled(true);
                    Recherche.this.rbGDiscriminant.setEnabled(true);
                    Recherche.this.lblSearchAtypique.setEnabled(true);
                    Recherche.this.rbKurtosisMax.setEnabled(true);
                    Recherche.this.rbFriedman.setEnabled(true);
                    Recherche.this.rbFriedmanTukey.setEnabled(true);
                    Recherche.this.rbDiscriminant.setEnabled(true);
                    Recherche.this.rbIndice4.setEnabled(true);
                    Recherche.this.rbStahelDonoho.setEnabled(true);
                    Recherche.this.lblTypeM.setEnabled(true);
                    Recherche.this.rbGA.setEnabled(true);
                    Recherche.this.rbPSO.setEnabled(true);
                    Recherche.this.rbTribes.setEnabled(true);
                    Recherche.this.rbMultiStart.setEnabled(true);
                    Recherche.this.lblParametres.setEnabled(true);
                    Recherche.this.lblIndividus.setEnabled(!Recherche.this.rbTribes.isSelected());
                    Recherche.this.txtNbIndividus.setEnabled(!Recherche.this.rbTribes.isSelected());
                    Recherche.this.lblIterations.setEnabled(true);
                    Recherche.this.txtNbIterations.setEnabled(true);
                    Recherche.this.lblDonnees.setEnabled(true);
                    Recherche.this.rbDOui.setEnabled(true);
                    Recherche.this.rbDNon.setEnabled(true);
                } else if (Recherche.this.frIhm.isModeDebutant()) {
                    if (Recherche.this.frIhm.isRechercheGroupe()) {
                        Recherche.this.lblSearchGroupe.setEnabled(true);
                        Recherche.this.rbGKurtosisMin.setEnabled(true);
                        Recherche.this.rbGFriedman.setEnabled(true);
                        Recherche.this.rbGDiscriminant.setEnabled(true);
                        Recherche.this.lblSearchAtypique.setEnabled(false);
                        Recherche.this.rbKurtosisMax.setEnabled(false);
                        Recherche.this.rbFriedman.setEnabled(false);
                        Recherche.this.rbFriedmanTukey.setEnabled(false);
                        Recherche.this.rbDiscriminant.setEnabled(false);
                        Recherche.this.rbIndice4.setEnabled(false);
                        Recherche.this.rbStahelDonoho.setEnabled(false);
                    } else {
                        Recherche.this.lblSearchGroupe.setEnabled(false);
                        Recherche.this.rbGKurtosisMin.setEnabled(false);
                        Recherche.this.rbGFriedman.setEnabled(false);
                        Recherche.this.rbGDiscriminant.setEnabled(false);
                        Recherche.this.lblSearchAtypique.setEnabled(true);
                        Recherche.this.rbKurtosisMax.setEnabled(true);
                        Recherche.this.rbFriedman.setEnabled(true);
                        Recherche.this.rbFriedmanTukey.setEnabled(true);
                        Recherche.this.rbDiscriminant.setEnabled(true);
                        Recherche.this.rbIndice4.setEnabled(true);
                        Recherche.this.rbStahelDonoho.setEnabled(true);
                    }
                    Recherche.this.lblTypeM.setEnabled(false);
                    Recherche.this.rbGA.setEnabled(false);
                    Recherche.this.rbPSO.setEnabled(false);
                    Recherche.this.rbTribes.setEnabled(false);
                    Recherche.this.rbMultiStart.setEnabled(false);
                    Recherche.this.lblParametres.setEnabled(false);
                    Recherche.this.lblIndividus.setEnabled(false);
                    Recherche.this.txtNbIndividus.setEnabled(false);
                    Recherche.this.lblIterations.setEnabled(false);
                    Recherche.this.txtNbIterations.setEnabled(false);
                    Recherche.this.lblDonnees.setEnabled(false);
                    Recherche.this.rbDOui.setEnabled(true);
                    Recherche.this.rbDNon.setEnabled(true);
                }
                Recherche.this.btLecture.setIcon(Recherche.this.play);
                Recherche.this.btLecture.setToolTipText(EPPLab.msg.getString("bt.lecture"));
                Recherche.this.btLecture.setEnabled(true);
                Recherche.this.btSuivant.setEnabled(true);
                Recherche.this.btStop.setEnabled(false);
                Recherche.this.txtNbLancements.setEnabled(true);
                Recherche.this.lblEnCours.setEnabled(false);
                Recherche.this.lblTemps.setEnabled(false);
                Recherche.this.btRetour.setEnabled(true);
                Recherche.this.cbListeSortie.setEnabled(true);
                JDialogFichier dlg = new JDialogFichier(Recherche.this, ((Recherche)Recherche.this).parametre.rep_sortie, new_fich, EPPLab.msg.getString("showInputDialog.sauverFichier"));
                String retour = dlg.afficher();
                File f_temp = new File(((Recherche)Recherche.this).parametre.rep_sortie + File.separatorChar + new_fich + ".temp");
                if (!"".equals(retour)) {
                    File f_dest = new File(((Recherche)Recherche.this).parametre.rep_sortie + File.separatorChar + retour);
                    boolean ecrasement = f_dest.exists();
                    if (ecrasement) {
                        f_dest.delete();
                    }
                    boolean copie = f_temp.renameTo(f_dest);
                    while (!copie) {
                        try {
                            Thread.sleep(1000L);
                            System.out.println("attendre");
                            copie = f_temp.renameTo(f_dest);
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (!ecrasement) {
                        ((Recherche)Recherche.this).frIhm.l_fichiers_sortie.add(retour);
                    }
                    Recherche.this.cbListeSortie.setSelectedItem(retour);
                } else {
                    f_temp.delete();
                }
                Recherche.this.pack();
                Recherche.this.stepByStep = false;
            }
        });
    }

    public void raz() {
        this.setSimuIterEnCours(0, 0);
        this.setAffTemps(0L, 0L);
        this.jpGraph.setVisible(false);
        this.pack();
    }

    public void setSimuIterEnCours(final int nb_simu, final int nb_iter) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Recherche.this.lblEnCours.setText(EPPLab.msg.getString("label.enCours") + "... " + nb_simu + " - " + nb_iter);
            }
        });
    }

    public void setAffTemps(final long tps_ecoule, final long tps_estime) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Recherche.this.lblTemps.setText(EPPLab.msg.getString("label.temps") + "... " + StringUtils.convertHMS(tps_ecoule) + " (" + StringUtils.convertHMS(tps_estime) + ")");
            }
        });
    }

    public void setGraphique(final double[] d) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Recherche.this.rbEstimateur.isSelected()) {
                    if (Recherche.this.estimateurNoyau == null) {
                        Recherche.this.estimateurNoyau = new EstimateurNoyau(6, 3, false, false, null);
                        Recherche.this.estimateurNoyau.setProjection(d);
                        Recherche.this.estimateurNoyau.repaint();
                        Recherche.this.jpGraph.add((Component)Recherche.this.estimateurNoyau, 1);
                        Recherche.this.pack();
                    } else {
                        Recherche.this.estimateurNoyau.setProjection(d);
                        Recherche.this.estimateurNoyau.repaint();
                    }
                } else if (Recherche.this.rbHistogramme.isSelected()) {
                    if (Recherche.this.histogramme == null) {
                        Recherche.this.histogramme = new Histogramme(6, 3, false, false, null);
                        Recherche.this.histogramme.setFichierDonnees(((Recherche)Recherche.this).parametre.ficherDeDonnees);
                        Recherche.this.histogramme.setProjection(d);
                        Recherche.this.histogramme.repaint();
                        Recherche.this.jpGraph.add((Component)Recherche.this.histogramme, 1);
                        Recherche.this.pack();
                    } else {
                        Recherche.this.histogramme.setProjection(d);
                        Recherche.this.histogramme.repaint();
                    }
                }
                if (!Recherche.this.jpGraph.isVisible()) {
                    Recherche.this.jpGraph.setVisible(true);
                    Recherche.this.pack();
                }
                Recherche.this.jpGraph.repaint();
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.rbGKurtosisMin && this.rbGKurtosisMin.isSelected()) {
            this.parametre.nomIndice = this.rbGKurtosisMin.getText();
        } else if (source == this.rbGFriedman && this.rbGFriedman.isSelected()) {
            this.parametre.nomIndice = this.rbGFriedman.getText();
        } else if (source == this.rbGDiscriminant && this.rbGDiscriminant.isSelected()) {
            this.parametre.nomIndice = this.rbGDiscriminant.getText();
        } else if (source == this.rbKurtosisMax && this.rbKurtosisMax.isSelected()) {
            this.parametre.nomIndice = this.rbKurtosisMax.getText();
        } else if (source == this.rbFriedman && this.rbFriedman.isSelected()) {
            this.parametre.nomIndice = this.rbFriedman.getText();
        } else if (source == this.rbDiscriminant && this.rbDiscriminant.isSelected()) {
            this.parametre.nomIndice = this.rbDiscriminant.getText();
        } else if (source == this.rbFriedmanTukey && this.rbFriedmanTukey.isSelected()) {
            this.parametre.nomIndice = this.rbFriedmanTukey.getText();
        } else if (source == this.rbIndice4 && this.rbIndice4.isSelected()) {
            this.parametre.nomIndice = this.rbIndice4.getText();
        } else if (source == this.rbStahelDonoho && this.rbStahelDonoho.isSelected()) {
            this.parametre.nomIndice = this.rbStahelDonoho.getText();
        } else if (source == this.rbGA && this.rbGA.isSelected()) {
            this.parametre.methode = "Genetic Algorithm";
            this.lblIndividus.setText(EPPLab.msg.getString("label.individu"));
            this.lblIndividus.setEnabled(true);
            this.txtNbIndividus.setEnabled(true);
            if (this.parametre.ficherDeDonnees.startsWith("lubischev")) {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(20);
            } else if (this.parametre.ficherDeDonnees.startsWith("don")) {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(20);
            } else if (this.parametre.ficherDeDonnees.startsWith("fiab")) {
                this.txtNbIndividus.setValeur(200);
                this.txtNbIterations.setValeur(50);
            } else if (this.parametre.ficherDeDonnees.startsWith("olive3")) {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(20);
            } else if (this.parametre.ficherDeDonnees.startsWith("olive")) {
                this.txtNbIndividus.setValeur(100);
                this.txtNbIterations.setValeur(50);
            } else {
                this.txtNbIndividus.setValeur(100);
                this.txtNbIterations.setValeur(50);
            }
        } else if (source == this.rbPSO && this.rbPSO.isSelected()) {
            this.parametre.methode = "Particule Swarm Optimization";
            this.lblIndividus.setText(EPPLab.msg.getString("label.particule"));
            this.lblIndividus.setEnabled(true);
            this.txtNbIndividus.setEnabled(true);
            if (this.parametre.ficherDeDonnees.startsWith("lubischev")) {
                this.txtNbIndividus.setValeur(20);
                this.txtNbIterations.setValeur(50);
            } else if (this.parametre.ficherDeDonnees.startsWith("don")) {
                this.txtNbIndividus.setValeur(20);
                this.txtNbIterations.setValeur(50);
            } else if (this.parametre.ficherDeDonnees.startsWith("fiab")) {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(200);
            } else if (this.parametre.ficherDeDonnees.startsWith("olive3")) {
                this.txtNbIndividus.setValeur(20);
                this.txtNbIterations.setValeur(50);
            } else if (this.parametre.ficherDeDonnees.startsWith("olive")) {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(100);
            } else {
                this.txtNbIndividus.setValeur(50);
                this.txtNbIterations.setValeur(100);
            }
        } else if (source == this.rbTribes && this.rbTribes.isSelected()) {
            this.parametre.methode = "Tribes";
            this.lblIndividus.setText(EPPLab.msg.getString("label.particule"));
            this.lblIndividus.setEnabled(false);
            this.txtNbIndividus.setEnabled(false);
            this.txtNbIndividus.setValeur(1);
            this.txtNbIterations.setValeur(100);
        } else if (source == this.rbMultiStart && this.rbMultiStart.isSelected()) {
            this.parametre.methode = "MultiStart";
            this.lblIndividus.setEnabled(false);
            this.txtNbIndividus.setEnabled(false);
            this.txtNbIndividus.setValeur(1);
            this.txtNbIterations.setValeur(400);
        } else if (source == this.rbDOui && this.rbDOui.isSelected()) {
            this.parametre.sphere = true;
        } else if (source == this.rbDNon && this.rbDNon.isSelected()) {
            this.parametre.sphere = false;
        }
    }
}

