## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message = FALSE---------------------------------------------------
library(PnT)
library(plotly)
mylar <- readRDS('../inst/extdata/mylar_data.rds')

## ----plot, out.width="100%"---------------------------------------------------
plot_ly(mylar, x = ~Ch, y = ~CPS,
        type = 'scatter', mode = 'lines')

## ----peaks--------------------------------------------------------------------
find_peaks(mylar, 'Ch', 'CPS')

## ----noisy data---------------------------------------------------------------
X <- seq(0, 10, 0.01)
Y <- sin(X) + runif(length(X), min=-0.1, max=0.1)
data <- data.frame(X=X, Y=Y)
plot_ly(data, x = ~X, y = ~Y,
        type = 'scatter', mode = 'lines')

## ----noisy peaks--------------------------------------------------------------
find_peaks(data, 'X', 'Y')

## -----------------------------------------------------------------------------
Y <- Y + runif(length(X), min=-0.1, max=0.1)
data <- data.frame(X=X, Y=Y)
find_peaks(data, 'X', 'Y')

## ----use filter---------------------------------------------------------------
find_peaks(data, 'X', 'Y', minYerror=0.2)

## -----------------------------------------------------------------------------
Y <- (7/(5+(X-5)^2)) + (0.05/(0.02+(X-8)^2)) + (0.03/(0.03+(X-1)^2))
data <- data.frame(X=X, Y=Y)
plot_ly(data, x = ~X, y = ~Y,
        type = 'scatter', mode = 'lines')

## -----------------------------------------------------------------------------
find_peaks(data, 'X', 'Y')

## -----------------------------------------------------------------------------
find_peaks(data, 'X', 'Y', minSlope = 1)

## -----------------------------------------------------------------------------
find_peaks(data, 'X', 'Y', edgeFilter = 0.25)

## ---- include = FALSE---------------------------------------------------------
school_data <- readRDS("../inst/extdata/school_data.rds")
jadeite_control <- readRDS("../inst/extdata/jadeite_control.rds")

## ----logy, message = FALSE----------------------------------------------------
logy <- function(figure){
  layout(figure, yaxis=list(type="log"))
}

## ----school-------------------------------------------------------------------
fig <- plot_ly(school_data, x=~Energy, y=~Counts, type="scatter", mode="lines"); fig

## ----find peaks---------------------------------------------------------------
find_peaks(school_data, 'Energy', 'Counts')

## ----log plot-----------------------------------------------------------------
logy(fig)

## ----asFraction---------------------------------------------------------------
find_peaks(school_data, 'Energy', 'Counts', asFraction = FALSE, minYerror = 60)

## ----jadeite control----------------------------------------------------------
fig <- plot_ly(jadeite_control, x=~Ch, y=~CPS, type="scatter", mode="lines"); fig

## -----------------------------------------------------------------------------
logy(fig)

## -----------------------------------------------------------------------------
find_peaks(jadeite_control, 'Ch', 'CPS', asFraction = FALSE, minYerror = 400)

## ----ROI----------------------------------------------------------------------
smallerPeaks <- find_peaks(jadeite_control, 'Ch', 'CPS', asFraction = FALSE, minYerror = 400, ROI = c(500, 1050))
smallerPeaks

## -----------------------------------------------------------------------------
largerPeaks <- find_peaks(jadeite_control, 'Ch', 'CPS', asFraction = FALSE, minYerror = 10000, ROI = c(0, 500))
largerPeaks

## ----bind rows----------------------------------------------------------------
dplyr::bind_rows(largerPeaks, smallerPeaks)

