## Help

### Welcome to MuPET-Flow! Multiple Ploidy Estimation Tool for all Species Compatible with Flow Cytometry.

MuPET-Flow is a graphical user interface tool to estimate ploidy from DNA cells stained with fluorescent dyes and analyzed by flow cytometry. It automates file uploading and configuration, peak fluorescence intensity detection, multiple histogram visualizations, peak error curation, ploidy and genome size calculations, and easy results export.

Once the application is launched, you can either:
1. Load your experimental data.
2. Run an in-app example by clicking the 'Example' button.

For the first case, selecting the channel where the data was acquired is mandatory. For the second case, the example channel `FL4-A` is automatically detected for demonstration purposes.

After launching the app, you can follow the app flow, which is divided into three tabs: _**Peaks**_, _**Regression**_ and _**Summary**_.  Below is a general description of the options available in each tab:

### Peaks
* **Select a sample (optional):** Allows visual exploration of individual samples if desired.
* **Adjust smoothing (optional):** Adjusts the histogram curve for noisy samples.
* **Adjust window width (optional):** Defines the interval where the app will look for peaks.
* **Select minimum cell count to call a peak (optional):** Useful for samples with a low number of events.
* **Select maximum number of peaks to plot (optional):** Useful for samples with heterogeneous populations where more peaks are present.

### Regression
* **Select type of analysis:** Choose between "Ploidy" or "Genome size" analysis.
* **Select number of standards:** A minimum of two standards is required.
* **Select standard samples and values:** This is the ploidy or genome size of your standards.

### Summary
* **Results preview:** Creates a compiled figure with histograms for all samples.
* **Save plot:** Saves the histograms in either PNG or TIFF format with customizable size and quality. Optionally, you can control the grid layout.
* **Save table:** Exports the parameters used and the estimated ploidy or genome size as a CSV file.

If any errors are detected, you can go back to the _**Peaks**_ tab to review the parameters. Note that the regression must also be re-done after parameter adjustments.

### Recent updates.

**December 16, 2024:** The app was prepared to be published in The Comprehensive R Archive Network (CRAN), which now installs all the dependencies automatically and provides in-app example data.

**June 14th, 2024:** A bug affecting histogram calculations for gated files was detected and fixed. Consequently, the peaks calculated with this new version may slightly differ from those generated by the previous version.

**April 12, 2024:** Significant change in histogram calculation: All files are now converted to histograms ranging from 0 to 1000, as opposed to using the bin scale of the instrument. This modification enables quicker processing of files from newer instruments capable of storing data in larger bin sizes.

### Known issues

* App works deletes `.fcs` and `.FCS` extensions from files names, and removes everything after a space to generate the sample name. If after this previous process duplicated names are generated, the app will crash, thus it is better to name the files with unique names
* Sometimes it crashes when uploading different samples, so it is better to close and re-run the app.
* Notice that when modifying the smoothing and window, it recalculates and deselect already chosen peaks.
* When files are large and exceed the maximum size, prior running the app you can set in your console: `options(shiny.maxRequestSize = 10 * 1024^2)`.
* It will give an error if window (span) is too small.

### Potential improvements
* Add safe code to avoid downloading empty documents.
* Add code to download individual histograms and linear regression plots.
* Add code to download regression summary as text.
* Add code to exclude samples from final summary histograms.
* Add code to download all detected peaks when more than two are detected.
* Generate new version of script to resume analysis using previously determined smoothing and window.
* Explain in help what is the plotted r and the pvalue.
